/*
 * Decompiled with CFR 0.152.
 */
package org.expath.exist;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.SequenceType;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpConnection;
import org.expath.httpclient.HttpRequest;
import org.expath.httpclient.HttpResponse;
import org.expath.httpclient.impl.ApacheHttpConnection;
import org.expath.httpclient.impl.RequestParser;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.exist.EXistResult;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.model.exist.EXistElement;
import org.expath.tools.model.exist.EXistSequence;

public class SendRequestFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(SendRequestFunction.class);
    private static final FunctionParameterSequenceType REQUEST_PARAM = new FunctionParameterSequenceType("request", 1, 3, "request contains the various parameters of the request, for instance the HTTP method to use or the HTTP headers. Among other things, it can also contain the other param's values: the URI and the bodies. If they are not set as parameter to the function, their value in $request, if any, is used instead. See the following section (http://www.expath.org/spec/http-client#d2e183) for the detailed definition of the http:request element. If the parameter does not follow the grammar defined in this spec, this is an error [err:HC005].");
    private static final FunctionParameterSequenceType HREF_PARAM = new FunctionParameterSequenceType("href", 22, 3, "$href is the HTTP or HTTPS URI to send the request to. It is an xs:anyURI, but is declared as a string to be able to pass literal strings (without requiring to explicitly cast it to an xs:anyURI)");
    private static final FunctionParameterSequenceType BODIES_PARAM = new FunctionParameterSequenceType("bodies", 11, 7, "$bodies is the request body content, for HTTP methods that can contain a body in the request (e.g. POST). This is an error if this param is not the empty sequence for methods that must be empty (e.g. DELETE). The details of the methods are defined in their respective specs (e.g. [RFC 2616] or [RFC 4918]). In case of a multipart request, it can be a sequence of several items, each one is the body of the corresponding body descriptor in $request.");
    private static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(11, 6, "A sequence representing the response from the server. This sequence has an http:response element as first item, which is followed by an additional item for each body or body part in the response. Further detail can be found here - http://www.expath.org/spec/http-client#d2e483");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("send-request", "http://expath.org/ns/http-client", "hc"), "Sends a HTTP request to a server and returns the response.", new SequenceType[]{REQUEST_PARAM}, (SequenceType)RETURN_TYPE), new FunctionSignature(new QName("send-request", "http://expath.org/ns/http-client", "hc"), "Sends a HTTP request to a server and returns the response.", new SequenceType[]{REQUEST_PARAM, HREF_PARAM}, (SequenceType)RETURN_TYPE), new FunctionSignature(new QName("send-request", "http://expath.org/ns/http-client", "hc"), "Sends a HTTP request to a server and returns the response.", new SequenceType[]{REQUEST_PARAM, HREF_PARAM, BODIES_PARAM}, (SequenceType)RETURN_TYPE)};

    public SendRequestFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public org.exist.xquery.value.Sequence eval(org.exist.xquery.value.Sequence[] args, org.exist.xquery.value.Sequence contextSequence) throws XPathException {
        org.exist.xquery.value.Sequence bodies = org.exist.xquery.value.Sequence.EMPTY_SEQUENCE;
        String href = null;
        NodeValue request = null;
        switch (this.getArgumentCount()) {
            case 3: {
                bodies = args[2];
            }
            case 2: {
                Item i = args[1].itemAt(0);
                if (i != null) {
                    href = i.getStringValue();
                }
            }
            case 1: {
                request = (NodeValue)args[0].itemAt(0);
                break;
            }
            default: {
                return org.exist.xquery.value.Sequence.EMPTY_SEQUENCE;
            }
        }
        return this.sendRequest(request, href, bodies);
    }

    private org.exist.xquery.value.Sequence sendRequest(NodeValue request, String href, org.exist.xquery.value.Sequence bodies) throws XPathException {
        HttpRequest req = null;
        try {
            EXistSequence b = new EXistSequence(bodies, this.getContext());
            EXistElement r = new EXistElement(request, this.getContext());
            RequestParser parser = new RequestParser((Element)r);
            req = parser.parse((Sequence)b, href);
            if (href != null && !href.isEmpty()) {
                req.setHref(href);
            }
            URI uri = new URI(req.getHref());
            EXistResult result = this.sendOnce(uri, req, parser);
            return result.getResult();
        }
        catch (URISyntaxException ex) {
            throw new XPathException((Expression)this, "Href is not valid: " + req != null ? req.getHref() : ". " + ex.getMessage(), (Throwable)ex);
        }
        catch (HttpClientException hce) {
            throw new XPathException((Expression)this, hce.getMessage(), (Throwable)hce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EXistResult sendOnce(URI uri, HttpRequest request, RequestParser parser) throws HttpClientException {
        EXistResult result = new EXistResult(this.getContext());
        ApacheHttpConnection conn = null;
        try {
            conn = new ApacheHttpConnection(uri);
            HttpResponse response = request.send((Result)result, (HttpConnection)conn, parser.getSendAuth() ? parser.getCredentials() : null);
            if (response.getStatus() == 401 && parser.getCredentials() != null) {
                result = new EXistResult(this.getContext());
                request.send((Result)result, (HttpConnection)conn, parser.getCredentials());
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (HttpClientException hcee) {
                    logger.warn(hcee.getMessage(), (Throwable)hcee);
                }
            }
        }
        return result;
    }
}

