/*
 * Decompiled with CFR 0.152.
 */
package org.expath.exist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xml.sax.SAXException;

public class ZipEntryFunctions
extends BasicFunction {
    protected static final Logger LOG = LogManager.getLogger(ZipEntryFunctions.class);
    private static final FunctionParameterSequenceType HREF_PARAM = new FunctionParameterSequenceType("href", 25, 2, "The URI for locating the Zip file");
    private static final FunctionParameterSequenceType ENTRY_PARAM = new FunctionParameterSequenceType("entry", 22, 2, "The entry within the Zip file to address");
    private static final String BINARY_ENTRY_NAME = "binary-entry";
    private static final String HTML_ENTRY_NAME = "html-entry";
    private static final String TEXT_ENTRY_NAME = "text-entry";
    private static final String XML_ENTRY_NAME = "xml-entry";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("binary-entry", "http://expath.org/ns/zip", "zip"), "Extracts the binary stream from the file positioned at $entry within the ZIP file identified by $href and returns it as a Base64 item.", new SequenceType[]{HREF_PARAM, ENTRY_PARAM}, (SequenceType)new FunctionReturnSequenceType(26, 2, "The binary representation of the entry from the Zip file.")), new FunctionSignature(new QName("html-entry", "http://expath.org/ns/zip", "zip"), "Extracts the html file positioned at $entry within the ZIP file identified by $href, and returns a document node. Because an HTML document is not necessarily a well-formed XML document, an implementation may use a specific parser in order to produce an XDM document node, like [TagSoup] or [HTML Tidy]; the details of this process are implementation-defined.", new SequenceType[]{HREF_PARAM, ENTRY_PARAM}, (SequenceType)new FunctionReturnSequenceType(6, 2, "The document-node of the entry from the Zip file.")), new FunctionSignature(new QName("text-entry", "http://expath.org/ns/zip", "zip"), "Extracts the contents of the text file positioned at entry within the ZIP file identified by $href and returns it as a string.", new SequenceType[]{HREF_PARAM, ENTRY_PARAM}, (SequenceType)new FunctionReturnSequenceType(22, 2, "The string value of the entry from the Zip file.")), new FunctionSignature(new QName("xml-entry", "http://expath.org/ns/zip", "zip"), "Extracts the content from the XML file positioned at $entry within the ZIP file identified by $href and returns it as a document-node.", new SequenceType[]{HREF_PARAM, ENTRY_PARAM}, (SequenceType)new FunctionReturnSequenceType(6, 2, "The document-node of the entry from the Zip file."))};

    public ZipEntryFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        XmldbURI uri = ((AnyURIValue)args[0].itemAt(0)).toXmldbURI();
        String entryName = args[1].itemAt(0).getStringValue();
        ZipFileFromDb zipFileSource = new ZipFileFromDb(uri);
        ZipInputStream zis = null;
        boolean mustClose = true;
        Sequence result = Sequence.EMPTY_SEQUENCE;
        try {
            ZipEntry zipEntry;
            zis = zipFileSource.getStream(this.context.getBroker());
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(entryName)) continue;
                if (this.isCalledAs(BINARY_ENTRY_NAME)) {
                    result = this.extractBinaryEntry(zis);
                    mustClose = false;
                } else if (this.isCalledAs(HTML_ENTRY_NAME)) {
                    result = this.extractHtmlEntry(zis);
                } else if (this.isCalledAs(TEXT_ENTRY_NAME)) {
                    result = this.extractStringEntry(zis);
                } else if (this.isCalledAs(XML_ENTRY_NAME)) {
                    result = this.extractXmlEntry(zis);
                }
                break;
            }
        }
        catch (IOException | PermissionDeniedException ioe) {
            LOG.error(ioe.getMessage(), ioe);
            throw new XPathException((Expression)this, ioe.getMessage(), ioe);
        }
        finally {
            if (zis != null && mustClose) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {
                    LOG.warn(ioe.getMessage(), (Throwable)ioe);
                }
            }
            zipFileSource.close();
        }
        return result;
    }

    private BinaryValue extractBinaryEntry(ZipInputStream zis) throws XPathException {
        return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)zis);
    }

    private StringValue extractStringEntry(ZipInputStream zis) throws XPathException, IOException {
        char[] buf = new char[4096];
        StringBuilder builder = new StringBuilder();
        int read = -1;
        try (InputStreamReader reader = new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8);){
            while ((read = reader.read(buf)) > -1) {
                builder.append(buf, 0, read);
            }
        }
        return new StringValue(builder.toString());
    }

    private org.exist.dom.memtree.DocumentImpl extractHtmlEntry(ZipInputStream zis) throws XPathException {
        try {
            return ModuleUtils.htmlToXHtml((XQueryContext)this.context, (Source)new StreamSource(zis), null, null);
        }
        catch (IOException | SAXException saxe) {
            throw new XPathException((Expression)this, saxe.getMessage(), (Throwable)saxe);
        }
    }

    private NodeValue extractXmlEntry(ZipInputStream zis) throws XPathException {
        try {
            return ModuleUtils.streamToXML((XQueryContext)this.context, (InputStream)zis);
        }
        catch (IOException | SAXException saxe) {
            throw new XPathException((Expression)this, saxe.getMessage(), (Throwable)saxe);
        }
    }

    protected static class ZipFileFromDb
    implements ZipFileSource {
        private BinaryDocument binaryDoc = null;
        private final XmldbURI uri;

        public ZipFileFromDb(XmldbURI uri) {
            this.uri = uri;
        }

        @Override
        public ZipInputStream getStream(DBBroker broker) throws IOException, PermissionDeniedException {
            if (this.binaryDoc == null) {
                this.binaryDoc = this.getDoc(broker);
            }
            return new ZipInputStream(broker.getBinaryResource(this.binaryDoc));
        }

        @Override
        public void close() {
            if (this.binaryDoc != null) {
                this.binaryDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }

        private BinaryDocument getDoc(DBBroker broker) throws PermissionDeniedException {
            DocumentImpl doc = broker.getXMLResource(this.uri, Lock.LockMode.READ_LOCK);
            if (doc == null) {
                return null;
            }
            if (doc.getResourceType() != 1) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                return null;
            }
            return (BinaryDocument)doc;
        }
    }

    public static interface ZipFileSource
    extends AutoCloseable {
        public ZipInputStream getStream(DBBroker var1) throws IOException, PermissionDeniedException;

        @Override
        public void close();
    }
}

