/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.model.exist;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.xquery.NodeTest;
import org.exist.xquery.TypeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.HttpResponse;
import org.expath.httpclient.model.Result;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.httpclient.model.exist.EXistTreeBuilder;
import org.xml.sax.SAXException;

public class EXistResult
implements Result {
    private static final Logger logger = LogManager.getLogger(EXistResult.class);
    ValueSequence result = new ValueSequence();
    private final XQueryContext context;

    public EXistResult(XQueryContext context) {
        this.context = context;
    }

    public Result makeNewResult() throws HttpClientException {
        return new EXistResult(this.context.copyContext());
    }

    public void add(Reader reader) throws HttpClientException {
        StringBuilder builder = new StringBuilder();
        try {
            char[] cbuf = new char[4096];
            int read = -1;
            while ((read = reader.read(cbuf)) > -1) {
                builder.append(cbuf, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new HttpClientException("Unable to add string value to result: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                logger.warn(ioe.getMessage(), (Throwable)ioe);
            }
        }
        this.result.add((Item)new StringValue(builder.toString()));
    }

    public void add(InputStream is) throws HttpClientException {
        try {
            this.result.add((Item)BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)is));
        }
        catch (XPathException xpe) {
            throw new HttpClientException("Unable to add binary value to result:" + xpe.getMessage(), (Throwable)xpe);
        }
    }

    public void add(Source src) throws HttpClientException {
        try {
            NodeValue nodeValue = ModuleUtils.sourceToXML((XQueryContext)this.context, (Source)src);
            this.result.add((Item)nodeValue);
        }
        catch (SAXException saxe) {
            throw new HttpClientException("Unable to add Source to result:" + saxe.getMessage(), (Throwable)saxe);
        }
        catch (IOException ioe) {
            throw new HttpClientException("Unable to add Source to result:" + ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void add(HttpResponse response) throws HttpClientException {
        EXistTreeBuilder builder = new EXistTreeBuilder(this.context);
        response.outputResponseElement((TreeBuilder)builder);
        DocumentImpl doc = builder.close();
        try {
            TypeTest kind = new TypeTest(1);
            if (this.result.isEmpty()) {
                doc.selectChildren((NodeTest)kind, (Sequence)this.result);
            } else {
                ValueSequence newResult = new ValueSequence();
                doc.selectChildren((NodeTest)kind, (Sequence)newResult);
                newResult.addAll((Sequence)this.result);
                this.result = newResult;
            }
        }
        catch (XPathException xpe) {
            throw new HttpClientException("Unable to add HttpResponse to result:" + xpe.getMessage(), (Throwable)xpe);
        }
    }

    public Sequence getResult() {
        return this.result;
    }
}

