/*
 * Decompiled with CFR 0.152.
 */
package org.expath.httpclient.model.exist;

import org.apache.http.Header;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.XQueryContext;
import org.expath.httpclient.HeaderSet;
import org.expath.httpclient.HttpClientException;
import org.expath.httpclient.model.TreeBuilder;
import org.expath.tools.ToolsException;

public class EXistTreeBuilder
implements TreeBuilder {
    final MemTreeBuilder builder;

    public EXistTreeBuilder(XQueryContext context) {
        this.builder = context.getDocumentBuilder();
        this.builder.startDocument();
    }

    public void startElem(String localname) throws ToolsException {
        String prefix = "hc";
        String uri = "http://expath.org/ns/http-client";
        this.builder.startElement(new QName(localname, "http://expath.org/ns/http-client", "hc"), null);
    }

    public void attribute(String localname, CharSequence value) throws ToolsException {
        this.builder.addAttribute(new QName(localname, ""), value.toString());
    }

    public void startContent() throws ToolsException {
    }

    public void endElem() throws ToolsException {
        this.builder.endElement();
    }

    public DocumentImpl close() {
        this.builder.endDocument();
        return this.builder.getDocument();
    }

    public void outputHeaders(HeaderSet headers) throws HttpClientException {
        for (Header h : headers) {
            assert (h.getName() != null) : "Header name cannot be null";
            String name = h.getName().toLowerCase();
            try {
                this.startElem("header");
                this.attribute("name", name);
                this.attribute("value", h.getValue());
                this.endElem();
            }
            catch (ToolsException ex) {
                throw new HttpClientException("Error building the header " + name, (Throwable)ex);
            }
        }
    }
}

