/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.model.exist;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Sequence;
import org.expath.tools.serial.SerialParameters;
import org.xml.sax.SAXException;

public class EXistSequence
implements Sequence {
    private final org.exist.xquery.value.Sequence sequence;
    private SequenceIterator sequenceIterator = SequenceIterator.EMPTY_ITERATOR;
    private final XQueryContext context;

    public EXistSequence(org.exist.xquery.value.Sequence sequence, XQueryContext context) throws XPathException {
        this.sequence = sequence;
        if (sequence != null) {
            this.sequenceIterator = sequence.iterate();
        }
        this.context = context;
    }

    public boolean isEmpty() throws ToolsException {
        return this.sequence.isEmpty();
    }

    public Sequence next() throws ToolsException {
        try {
            Item item = this.sequenceIterator.nextItem();
            org.exist.xquery.value.Sequence singleton = (org.exist.xquery.value.Sequence)item;
            return new EXistSequence(singleton, this.context);
        }
        catch (XPathException xpe) {
            throw new ToolsException(xpe.getMessage(), (Throwable)xpe);
        }
    }

    public void serialize(OutputStream out, SerialParameters params) throws ToolsException {
        Properties props = params == null ? null : this.makeOutputProperties(params);
        props.setProperty("sax-document-events", "false");
        String encoding = props.getProperty("encoding", StandardCharsets.UTF_8.name());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), encoding);){
            XQuerySerializer xqSerializer = new XQuerySerializer(this.context.getBroker(), props, (Writer)writer);
            xqSerializer.serialize(this.sequence);
        }
        catch (IOException | XPathException | SAXException e) {
            throw new ToolsException("A problem occurred while serializing the node set: " + e.getMessage(), e);
        }
    }

    private Properties makeOutputProperties(SerialParameters params) throws ToolsException {
        Properties props = new Properties();
        this.setOutputKey(props, "method", params.getMethod());
        this.setOutputKey(props, "media-type", params.getMediaType());
        this.setOutputKey(props, "encoding", params.getEncoding());
        this.setOutputKey(props, "cdata-section-elements", params.getCdataSectionElements());
        this.setOutputKey(props, "doctype-public", params.getDoctypePublic());
        this.setOutputKey(props, "doctype-system", params.getDoctypeSystem());
        this.setOutputKey(props, "indent", params.getIndent());
        this.setOutputKey(props, "omit-xml-declaration", params.getOmitXmlDeclaration());
        this.setOutputKey(props, "standalone", params.getStandalone());
        this.setOutputKey(props, "version", params.getVersion());
        return props;
    }

    private void setOutputKey(Properties props, String name, String value) throws ToolsException {
        if (value != null) {
            props.setProperty(name, value);
        }
    }

    private void setOutputKey(Properties props, String name, Boolean value) throws ToolsException {
        if (value != null) {
            props.setProperty(name, value != false ? "yes" : "no");
        }
    }

    private void setOutputKey(Properties props, String name, SerialParameters.Standalone value) throws ToolsException {
        if (value != null) {
            switch (value) {
                case YES: {
                    props.setProperty(name, "yes");
                    break;
                }
                case NO: {
                    props.setProperty(name, "no");
                    break;
                }
                case OMIT: {
                    props.setProperty(name, "omit");
                    break;
                }
                default: {
                    throw new ToolsException("Invalid Standalone value: " + value);
                }
            }
        }
    }

    private void setOutputKey(Properties props, String name, QName value) throws ToolsException {
        if (value != null) {
            if (value.getNamespaceURI() != null && !value.getNamespaceURI().equals("")) {
                throw new ToolsException("A QName with a non-null namespace not supported as a serialization param: {" + value.getNamespaceURI() + "}" + value.getLocalPart());
            }
            props.setProperty(name, value.getLocalPart());
        }
    }

    private void setOutputKey(Properties props, String name, Iterable<QName> value) throws ToolsException {
        if (value != null) {
            StringBuilder buf = new StringBuilder();
            for (QName qname : value) {
                if (qname.getNamespaceURI() != null) {
                    throw new ToolsException("A QName with a non-null namespace not supported as a serialization param: {" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
                }
                buf.append(qname.getLocalPart());
                buf.append(" ");
            }
            props.setProperty(name, buf.toString());
        }
    }
}

