/*
 * Decompiled with CFR 0.152.
 */
package org.exquery;

public enum InternetMediaType {
    APPLICATION_OCTET_STREAM(Type.APPLICATION, "octet-stream"),
    APPLICATION_JSON(Type.APPLICATION, "json"),
    APPLICATION_XML(Type.APPLICATION, "xml"),
    APPLICATION_XHTML_XML(Type.APPLICATION, "xhtml+xml"),
    APPLICATION_PDF(Type.APPLICATION, "pdf"),
    APPLICATION_ANY(Type.APPLICATION),
    TEXT_HTML(Type.TEXT, "html"),
    TEXT_PLAIN(Type.TEXT, "plain"),
    ANY("*");

    public static final char SUBTYPE_DELIMITER = '/';
    public static final char WILDCARD = '*';
    private final String typeName;
    private final String subTypeName;

    private InternetMediaType(Type type, String subTypeName) {
        this.typeName = type.getName();
        this.subTypeName = subTypeName;
    }

    private InternetMediaType(String typeName, String subTypeName) {
        this.typeName = typeName;
        this.subTypeName = subTypeName;
    }

    private InternetMediaType(Type type) {
        this.typeName = type.getName();
        this.subTypeName = String.valueOf('*');
    }

    private InternetMediaType(String typeName) {
        this.typeName = typeName;
        this.subTypeName = String.valueOf('*');
    }

    public final String getMediaType() {
        return this.typeName + '/' + this.subTypeName;
    }

    public static enum Type {
        APPLICATION("application"),
        TEXT("text");

        final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

