/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.InternetMediaType;

public class AcceptHeader {
    private static final char PARAMETER_SEPARATOR = ';';
    private static final char QUALITY_PARAMETER = 'q';
    private static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
    private static final String QUALITY_FACTOR_REGEX = "(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?)";
    private static final String QUALITY_PARAM_REGEX = ";\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?)";
    private static final String TOKEN_REGEX = "[a-z]+";
    private static final String QUOTED_STRING = "\"[a-z0-9]+\"";
    private static final String EXTENSION_PARAM_REGEX = ";\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\")";
    private static final String acceptParams_regExp = "(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?";
    public static final String anyRange_regExp = "\\*\\/\\*";
    public static final String anySubtype_regExp = "[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*";
    public static final String accept_regExp = "(?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?";
    public static final Pattern ptnAccept = Pattern.compile("(?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?");
    public static final String accepts_regExp = "((?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?)(,\\s?(?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?)*";
    public static final Pattern ptnAccepts = Pattern.compile("((?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?)(,\\s?(?:(?:\\*\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}))(?:;\\s?q=(?:0(?:\\.[0-9]{1,3})?)|(?:1(?:\\.[0]{1,3})?))?\\s?(?:;\\s?[a-z]+=[a-z]+|(?:\"[a-z0-9]+\"))?)*");
    private final List<Accept> accepts = new ArrayList<Accept>();

    public AcceptHeader(String headerValue) {
        Matcher mtcAccepts = ptnAccepts.matcher(headerValue);
        if (!mtcAccepts.matches()) {
            throw new IllegalArgumentException("Invalid Accept Header Value: '" + headerValue + "' in respect to pattern: '" + ptnAccepts.pattern() + "'");
        }
        Matcher mtcAccept = ptnAccept.matcher(headerValue);
        while (mtcAccept.find()) {
            Accept accept;
            String acceptStr = mtcAccept.group();
            if (acceptStr == null) continue;
            if (acceptStr.indexOf(59) == -1) {
                accept = new Accept(acceptStr.trim());
            } else {
                String[] parts = acceptStr.split(String.valueOf(';'));
                String mediaRange = parts[0];
                if (parts[1].trim().startsWith(String.valueOf('q') + '=')) {
                    float qualityFactor = Float.parseFloat(parts[1].trim().substring(parts[1].trim().indexOf(61) + 1));
                    if (parts.length == 3) {
                        String[] extension = parts[2].trim().split(String.valueOf('='));
                        accept = new Accept(mediaRange, qualityFactor, new Accept.Extension(extension[0], extension[1]));
                    } else {
                        accept = new Accept(mediaRange, qualityFactor);
                    }
                } else {
                    String[] extension = parts[1].trim().split(String.valueOf('='));
                    accept = new Accept(mediaRange, new Accept.Extension(extension[0], extension[1]));
                }
            }
            this.accepts.add(accept);
        }
        Collections.sort(this.accepts);
    }

    public List<Accept> getAccepts() {
        return this.accepts;
    }

    public static class Accept
    implements Comparable<Accept> {
        private static final float DEFAULT_QUALITY_FACTOR = 1.0f;
        final String mediaRange;
        final float qualityFactor;
        final Extension extension;

        public Accept(String mediaRange) {
            this(mediaRange, 1.0f);
        }

        public Accept(InternetMediaType internetMediaType) {
            this(internetMediaType.getMediaType());
        }

        public Accept(String mediaRange, float qualityFactor) {
            this(mediaRange, qualityFactor, null);
        }

        public Accept(InternetMediaType internetMediaType, float qualityFactor) {
            this(internetMediaType.getMediaType(), qualityFactor);
        }

        public Accept(String mediaRange, Extension extension) {
            this(mediaRange, 1.0f, extension);
        }

        public Accept(String mediaRange, float qualityFactor, Extension extension) {
            this.mediaRange = mediaRange;
            this.qualityFactor = qualityFactor;
            this.extension = extension;
        }

        @Override
        public int compareTo(Accept other) {
            return Math.round(other.qualityFactor * 10.0f) - Math.round(this.qualityFactor * 10.0f);
        }

        public String getMediaRange() {
            return this.mediaRange;
        }

        public float getQualityFactor() {
            return this.qualityFactor;
        }

        public Extension getExtension() {
            return this.extension;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getMediaRange());
            if (this.getQualityFactor() != 1.0f) {
                builder.append(';');
                builder.append('q');
                builder.append('=');
                builder.append(this.getQualityFactor());
            }
            if (this.getExtension() != null) {
                builder.append(';');
                builder.append(this.getExtension().toString());
            }
            return builder.toString();
        }

        public boolean equals(Object other) {
            Accept otherAccept;
            boolean equals = other != null && other instanceof Accept ? (otherAccept = (Accept)other).getMediaRange().equals(this.getMediaRange()) && otherAccept.getQualityFactor() == this.getQualityFactor() && otherAccept.getExtension() == this.getExtension() : false;
            return equals;
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + (this.mediaRange != null ? this.mediaRange.hashCode() : 0);
            hash = 23 * hash + Float.floatToIntBits(this.qualityFactor);
            hash = 23 * hash + (this.extension != null ? this.extension.hashCode() : 0);
            return hash;
        }

        public static class Extension {
            final String name;
            final String value;

            public Extension(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.name + '=' + this.value;
            }

            public boolean equals(Object other) {
                Extension otherExtension;
                boolean equals = other != null && other instanceof Extension ? (otherExtension = (Extension)other).getName().equals(this.getName()) && otherExtension.getValue().equals(this.getValue()) : false;
                return equals;
            }

            public int hashCode() {
                int hash = 7;
                hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
                hash = 61 * hash + (this.value != null ? this.value.hashCode() : 0);
                return hash;
            }
        }
    }
}

