/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentTypeHeader {
    private static final String CHARSET_SEPARATOR = ";";
    private static final String CHARSET_KEY = "charset";
    private static final String CHARSET_KEY_VALUE_SEPARATOR = "=";
    public static final String contentType_regExp = "([a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127})(;\\s*charset=(.+))?";
    public static final Pattern ptnContentType = Pattern.compile("([a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127})(;\\s*charset=(.+))?");
    private static final Pattern ptnInternetMediaType = Pattern.compile("[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}");
    private final String internetMediaType;
    private final String charset;

    public ContentTypeHeader(String headerValue) throws IllegalArgumentException {
        Matcher mtcContentType = ptnContentType.matcher(headerValue);
        if (!mtcContentType.matches()) {
            throw new IllegalArgumentException("Invalid Content-Type Header Value: '" + headerValue + "' in respect to pattern: '" + ptnContentType.pattern() + "'");
        }
        this.internetMediaType = mtcContentType.group(1);
        this.charset = mtcContentType.groupCount() == 3 ? mtcContentType.group(3) : null;
    }

    public ContentTypeHeader(String internetMediaType, String charset) {
        Matcher mtcInternetMediaType = ptnInternetMediaType.matcher(internetMediaType);
        if (!mtcInternetMediaType.matches()) {
            throw new IllegalArgumentException("Invalid Internet Media Type value: '" + internetMediaType + "' in respect to pattern: '" + ptnInternetMediaType.pattern() + "'");
        }
        this.internetMediaType = internetMediaType;
        this.charset = charset;
    }

    public String getInternetMediaType() {
        return this.internetMediaType;
    }

    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getInternetMediaType());
        if (this.charset != null && !this.charset.isEmpty()) {
            builder.append(CHARSET_SEPARATOR).append(" ").append(CHARSET_KEY).append(CHARSET_KEY_VALUE_SEPARATOR).append(this.charset);
        }
        return builder.toString();
    }
}

