/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ServletRequest;
import com.bradmcevoy.http.ServletResponse;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringAwareMiltonServlet
implements Servlet {
    private Logger log = LoggerFactory.getLogger(SpringAwareMiltonServlet.class);
    ServletConfig config;
    ApplicationContext context;
    HttpManager httpManager;
    private ServletContext servletContext;
    private static final ThreadLocal<HttpServletRequest> originalRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> originalResponse = new ThreadLocal();

    public static HttpServletRequest request() {
        return originalRequest.get();
    }

    public static HttpServletResponse response() {
        return originalResponse.get();
    }

    public static void forward(String url) {
        try {
            SpringAwareMiltonServlet.request().getRequestDispatcher(url).forward((javax.servlet.ServletRequest)originalRequest.get(), (javax.servlet.ServletResponse)originalResponse.get());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.config = config;
            this.servletContext = config.getServletContext();
            this.context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
            this.httpManager = (HttpManager)this.context.getBean("milton.http.manager");
        }
        catch (Throwable ex) {
            this.log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            originalRequest.set(req);
            originalResponse.set(resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process((Request)request, (Response)response);
        }
        finally {
            originalRequest.remove();
            originalResponse.remove();
            servletResponse.getOutputStream().flush();
            servletResponse.flushBuffer();
        }
    }

    public String getServletInfo() {
        return "SpringAwareMiltonServlet";
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void destroy() {
    }
}

