/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.MiltonServlet;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ServletRequest;
import com.bradmcevoy.http.ServletResponse;
import com.bradmcevoy.http.http11.DefaultHttp11ResponseHandler;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class SpringMiltonFilter
implements Filter {
    private ClassPathXmlApplicationContext context;
    private HttpManager httpManager;
    private FilterConfig filterConfig;
    private ServletContext servletContext;
    private String[] excludeMiltonPaths;

    public void init(FilterConfig fc) throws ServletException {
        StaticApplicationContext parent = new StaticApplicationContext();
        parent.getBeanFactory().registerSingleton("servletContext", (Object)fc.getServletContext());
        parent.refresh();
        this.context = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"}, (ApplicationContext)parent);
        this.httpManager = (HttpManager)this.context.getBean("milton.http.manager");
        this.httpManager.setBuffering(DefaultHttp11ResponseHandler.BUFFERING.never);
        this.filterConfig = fc;
        this.servletContext = fc.getServletContext();
        String sExcludePaths = fc.getInitParameter("milton.exclude.paths");
        this.excludeMiltonPaths = sExcludePaths.split(",");
    }

    public void doFilter(javax.servlet.ServletRequest req, javax.servlet.ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)req;
            String url = hsr.getRequestURI();
            for (String s : this.excludeMiltonPaths) {
                if (!url.startsWith(s)) continue;
                fc.doFilter(req, resp);
                return;
            }
        } else {
            fc.doFilter(req, resp);
            return;
        }
        this.doMiltonProcessing((HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public void destroy() {
        this.context.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMiltonProcessing(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            MiltonServlet.setThreadlocals(req, resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process((Request)request, (Response)response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            resp.getOutputStream().flush();
            resp.flushBuffer();
        }
    }
}

