/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;

public class SitesConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SitesConfiguration> {
    private static final int DEFAULT_BACKUP_COUNT = 2;
    private final List<BackupConfigurationBuilder> backups = new ArrayList<BackupConfigurationBuilder>(2);
    private Set<String> inUseBackupSites = new HashSet<String>(2);
    private final BackupForBuilder backupForBuilder;
    private boolean disableBackups;

    public SitesConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.backupForBuilder = new BackupForBuilder(builder);
    }

    public BackupConfigurationBuilder addBackup() {
        BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
        this.backups.add(bcb);
        return bcb;
    }

    public List<BackupConfigurationBuilder> backups() {
        return this.backups;
    }

    public BackupForBuilder backupFor() {
        return this.backupForBuilder;
    }

    public void validate() {
        this.backupForBuilder.validate();
        HashSet<String> backupNames = new HashSet<String>(2);
        for (BackupConfigurationBuilder bcb : this.backups) {
            if (backupNames.add(bcb.site())) continue;
            throw new CacheConfigurationException("Multiple sites with name '" + bcb.site() + "' are configured. That is not allowed!");
        }
        for (String site : this.inUseBackupSites) {
            boolean found = false;
            for (BackupConfigurationBuilder bcb : this.backups) {
                if (!bcb.site().equals(site)) continue;
                found = true;
            }
            if (found) continue;
            throw new CacheConfigurationException("The site '" + site + "' should be defined within the set of backups!");
        }
    }

    public SitesConfiguration create() {
        ArrayList<BackupConfiguration> backupConfigurations = new ArrayList<BackupConfiguration>(2);
        for (BackupConfigurationBuilder bcb : this.backups) {
            backupConfigurations.add(bcb.create());
        }
        return new SitesConfiguration(backupConfigurations, this.backupForBuilder.create(), this.disableBackups, this.inUseBackupSites);
    }

    public Builder read(SitesConfiguration template) {
        this.backupForBuilder.read(template.backupFor());
        for (BackupConfiguration bc : template.allBackups()) {
            BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
            bcb.read(bc);
            this.backups.add(bcb);
        }
        this.disableBackups = template.disableBackups();
        return this;
    }

    public void disableBackups(boolean disable) {
        this.disableBackups = disable;
    }

    public SitesConfigurationBuilder addInUseBackupSite(String site) {
        this.inUseBackupSites.add(site);
        return this;
    }
}

