/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverImpl;
import org.infinispan.xsite.BackupReceiverRepository;
import org.jgroups.protocols.relay.SiteAddress;

@Listener
public class BackupReceiverRepositoryImpl
implements BackupReceiverRepository {
    private static Log log = LogFactory.getLog(BackupReceiverRepositoryImpl.class);
    private final ConcurrentMap<SiteCachePair, BackupReceiver> backupReceivers = new ConcurrentHashMap<SiteCachePair, BackupReceiver>();
    public EmbeddedCacheManager cacheManager;

    @Inject
    public void setup(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Start
    public void start() {
        this.cacheManager.addListener(this);
    }

    @Stop
    public void stop() {
        this.cacheManager.removeListener(this);
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent cse) {
        log.debugf("Processing cache stop: %s. Cache name: '%s'", cse, cse.getCacheName());
        for (SiteCachePair scp : this.backupReceivers.keySet()) {
            log.debugf("Processing entry %s", scp);
            if (!scp.localCacheName.equals(cse.getCacheName())) continue;
            log.debugf("Deregistering backup receiver %s", scp);
            this.backupReceivers.remove(scp);
        }
    }

    @Override
    public Object handleRemoteCommand(SingleRpcCommand cmd, SiteAddress src) throws Throwable {
        log.tracef("Handling command %s from remote site %s", cmd, src);
        String name = cmd.getCacheName();
        BackupReceiver localBackupCache = this.getBackupCacheManager(src.getSite(), name);
        return localBackupCache.handleRemoteCommand((VisitableCommand)cmd.getCommand());
    }

    public BackupReceiver getBackupCacheManager(String remoteSite, String remoteCache) {
        SiteCachePair toLookFor = new SiteCachePair(remoteCache, remoteSite);
        BackupReceiver backupManager = (BackupReceiver)this.backupReceivers.get(toLookFor);
        if (backupManager != null) {
            return backupManager;
        }
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        if (this.isBackupForRemoteCache(remoteSite, remoteCache, dcc, "___defaultcache")) {
            Cache cache = this.cacheManager.getCache();
            this.backupReceivers.putIfAbsent(toLookFor, new BackupReceiverImpl(cache));
            toLookFor.setLocalCacheName("___defaultcache");
            return (BackupReceiver)this.backupReceivers.get(toLookFor);
        }
        Set<String> cacheNames = this.cacheManager.getCacheNames();
        for (String name : cacheNames) {
            Configuration cacheConfiguration = this.cacheManager.getCacheConfiguration(name);
            if (!this.isBackupForRemoteCache(remoteSite, remoteCache, cacheConfiguration, name)) continue;
            Cache cache = this.cacheManager.getCache(name);
            toLookFor.setLocalCacheName(name);
            this.backupReceivers.putIfAbsent(toLookFor, new BackupReceiverImpl(cache));
            return (BackupReceiver)this.backupReceivers.get(toLookFor);
        }
        log.debugf("Did not find any backup explicitly configured backup cache for remote cache/site: %s/%s. Using %s", remoteSite, remoteCache, remoteCache);
        Cache cache = this.cacheManager.getCache(remoteCache);
        this.backupReceivers.putIfAbsent(toLookFor, new BackupReceiverImpl(cache));
        toLookFor.setLocalCacheName(cache.getName());
        return (BackupReceiver)this.backupReceivers.get(toLookFor);
    }

    private boolean isBackupForRemoteCache(String remoteSite, String remoteCache, Configuration cacheConfiguration, String name) {
        boolean found = cacheConfiguration.sites().backupFor().isBackupFor(remoteSite, remoteCache);
        if (found) {
            log.tracef("Found local cache '%s' is backup for cache '%s' from site '%s'", name, remoteCache, remoteSite);
        }
        return found;
    }

    public void replace(String site, String cache, BackupReceiver bcr) {
        this.backupReceivers.replace(new SiteCachePair(cache, site), bcr);
    }

    public BackupReceiver getBackupReceiver(String site, String cache) {
        return (BackupReceiver)this.backupReceivers.get(new SiteCachePair(site, cache));
    }

    static class SiteCachePair {
        public final String remoteSite;
        public final String remoteCache;
        public String localCacheName;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SiteCachePair)) {
                return false;
            }
            SiteCachePair that = (SiteCachePair)o;
            if (this.remoteCache != null ? !this.remoteCache.equals(that.remoteCache) : that.remoteCache != null) {
                return false;
            }
            return !(this.remoteSite != null ? !this.remoteSite.equals(that.remoteSite) : that.remoteSite != null);
        }

        public int hashCode() {
            int result = this.remoteSite != null ? this.remoteSite.hashCode() : 0;
            result = 31 * result + (this.remoteCache != null ? this.remoteCache.hashCode() : 0);
            return result;
        }

        SiteCachePair(String remoteCache, String remoteSite) {
            this.remoteCache = remoteCache;
            this.remoteSite = remoteSite;
        }

        public void setLocalCacheName(String localCacheName) {
            this.localCacheName = localCacheName;
        }

        public String toString() {
            return "SiteCachePair{site='" + this.remoteSite + '\'' + ", cache='" + this.remoteCache + '\'' + '}';
        }
    }
}

