/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.xquery;

public enum Cardinality {
    ZERO(1),
    ONE(2),
    MANY(4),
    ZERO_OR_ONE(ZERO, ONE),
    ZERO_OR_MORE(ZERO, ONE, MANY),
    ONE_OR_MORE(ONE, MANY);

    private int value;

    private Cardinality(int value) {
        this.value = value;
    }

    private Cardinality(Cardinality ... cardinalities) {
        for (Cardinality cardinality : cardinalities) {
            this.value |= cardinality.value;
        }
    }

    public boolean hasRequiredCardinality(Cardinality requiredCardinality) {
        return (requiredCardinality.value & this.value) == requiredCardinality.value;
    }

    public int getNumericValue() {
        return this.value;
    }
}

