/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.serial;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Element;
import org.expath.tools.serial.ExtensionHandler;

public class SerialParameters {
    private Boolean myByteOrderMark;
    private Set<QName> myCdataSectionElements;
    private String myDoctypePublic;
    private String myDoctypeSystem;
    private String myEncoding;
    private Boolean myEscapeUriAttributes;
    private Double myHtmlVersion;
    private Boolean myIncludeContentType;
    private Boolean myIndent;
    private String myItemSeparator;
    private String myMediaType;
    private QName myMethod;
    private String myNormalizationForm;
    private Boolean myOmitXmlDeclaration;
    private Standalone myStandalone;
    private Set<QName> mySuppressIndentation;
    private Boolean myUndeclarePrefixes;
    private Set<UseChar> myUseCharacterMaps;
    private String myVersion;
    private ExtensionHandler myHandler;
    private static final String SERIAL_NS_URI = "http://www.w3.org/2010/xslt-xquery-serialization";
    private static final String SERIAL_PARAMS_NAME = "serialization-parameters";
    private static final String CHAR_MAP_NAME = "character-map";
    private static final String CHAR_ATTR_NAME = "character";
    private static final String MAP_STRING_ATTR_NAME = "map-string";
    private static final String SERIAL_VALUE_NAME = "value";
    private static final String BYTE_ORDER_MARK_NAME = "byte-order-mark";
    private static final String CDATA_SECTION_ELEMENTS_NAME = "cdata-section-elements";
    private static final String DOCTYPE_PUBLIC_NAME = "doctype-public";
    private static final String DOCTYPE_SYSTEM_NAME = "doctype-system";
    private static final String ENCODING_NAME = "encoding";
    private static final String ESCAPE_URI_ATTRIBUTES_NAME = "escape-uri-attributes";
    private static final String HTML_VERSION_NAME = "html-version";
    private static final String INCLUDE_CONTENT_TYPE_NAME = "include-content-type";
    private static final String INDENT_NAME = "indent";
    private static final String ITEM_SEPARATOR_NAME = "item-separator";
    private static final String MEDIA_TYPE_NAME = "media-type";
    private static final String METHOD_NAME = "method";
    private static final String NORMALIZATION_FORM_NAME = "normalization-form";
    private static final String OMIT_XML_DECLARATION_NAME = "omit-xml-declaration";
    private static final String STANDALONE_NAME = "standalone";
    private static final String SUPPRESS_INDENTATION_NAME = "suppress-indentation";
    private static final String UNDECLARE_PREFIXES_NAME = "undeclare-prefixes";
    private static final String USE_CHARACTER_MAPS_NAME = "use-character-maps";
    private static final String VERSION_NAME = "version";

    public static SerialParameters parse(Element elem) throws ToolsException {
        if (null == elem) {
            throw new NullPointerException("Element for serialization parameters is null");
        }
        String ns = elem.getNamespaceUri();
        String name = elem.getLocalName();
        if (!SERIAL_NS_URI.equals(ns) || !SERIAL_PARAMS_NAME.equals(name)) {
            throw new ToolsException("Element name incorrect: {" + ns + "}" + name);
        }
        SerialParameters params = new SerialParameters();
        for (Element child : elem.children()) {
            String child_ns = child.getNamespaceUri();
            String child_name = child.getLocalName();
            String value = child.getAttribute(SERIAL_VALUE_NAME);
            if (null == value) {
                throw new ToolsException("No @value on the element: {" + ns + "}" + name);
            }
            if (SERIAL_NS_URI.equals(child_ns)) {
                switch (child_name) {
                    case "byte-order-mark": {
                        params.setByteOrderMark(value);
                        break;
                    }
                    case "cdata-section-elements": {
                        params.setCdataSectionElements(value, child);
                        break;
                    }
                    case "doctype-public": {
                        params.setDoctypePublic(value);
                        break;
                    }
                    case "doctype-system": {
                        params.setDoctypeSystem(value);
                        break;
                    }
                    case "encoding": {
                        params.setEncoding(value);
                        break;
                    }
                    case "escape-uri-attributes": {
                        params.setEscapeUriAttributes(value);
                        break;
                    }
                    case "html-version": {
                        params.setHtmlVersion(value);
                        break;
                    }
                    case "include-content-type": {
                        params.setIncludeContentType(value);
                        break;
                    }
                    case "indent": {
                        params.setIndent(value);
                        break;
                    }
                    case "item-separator": {
                        params.setItemSeparator(value);
                        break;
                    }
                    case "media-type": {
                        params.setMediaType(value);
                        break;
                    }
                    case "method": {
                        QName qname = value.indexOf(58) < 0 ? new QName(value) : child.parseQName(value);
                        params.setMethod(qname);
                        break;
                    }
                    case "normalization-form": {
                        params.setNormalizationForm(value);
                        break;
                    }
                    case "omit-xml-declaration": {
                        params.setOmitXmlDeclaration(value);
                        break;
                    }
                    case "standalone": {
                        params.setStandalone(value);
                        break;
                    }
                    case "suppress-indentation": {
                        params.setSuppressIndentation(value, child);
                        break;
                    }
                    case "undeclare-prefixes": {
                        params.setUndeclarePrefixes(value);
                        break;
                    }
                    case "use-character-maps": {
                        params.setUseCharacterMaps(value, child);
                        break;
                    }
                    case "version": {
                        params.setVersion(value);
                        break;
                    }
                    default: {
                        throw new ToolsException("Unknown serialization param: {" + child_ns + "}" + child_name);
                    }
                }
                continue;
            }
            QName qn = new QName(child_ns, child_name);
            params.setExtension(qn, value);
        }
        return params;
    }

    public void setExtensionHandler(ExtensionHandler handler) throws ToolsException {
        this.myHandler = handler;
    }

    public String getExtension(QName n) throws ToolsException {
        if (this.myHandler == null) {
            return null;
        }
        return this.myHandler.getExtension(n);
    }

    public void setExtension(QName n, String v) throws ToolsException {
        if (this.myHandler == null) {
            throw new ToolsException("No handler set for extension serialization parameters, name=" + n);
        }
        this.myHandler.setExtension(n, v);
    }

    public Boolean getByteOrderMark() {
        return this.myByteOrderMark;
    }

    public void setByteOrderMark(Boolean v) {
        this.myByteOrderMark = v;
    }

    public void setByteOrderMark(String v) throws ToolsException {
        this.setByteOrderMark(this.parseBoolean(v));
    }

    public Iterable<QName> getCdataSectionElements() {
        return this.myCdataSectionElements;
    }

    public void setCdataSectionElements(Iterable<QName> v) {
        this.myCdataSectionElements = new HashSet<QName>();
        for (QName q : v) {
            this.myCdataSectionElements.add(q);
        }
    }

    public void setCdataSectionElements(String v, Element scope) throws ToolsException {
        this.myCdataSectionElements = this.parseQNames(v, scope);
    }

    public String getDoctypePublic() {
        return this.myDoctypePublic;
    }

    public void setDoctypePublic(String v) {
        this.myDoctypePublic = v;
    }

    public String getDoctypeSystem() {
        return this.myDoctypeSystem;
    }

    public void setDoctypeSystem(String v) {
        this.myDoctypeSystem = v;
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public void setEncoding(String v) {
        this.myEncoding = v;
    }

    public Boolean getEscapeUriAttributes() {
        return this.myEscapeUriAttributes;
    }

    public void setEscapeUriAttributes(Boolean v) {
        this.myEscapeUriAttributes = v;
    }

    public void setEscapeUriAttributes(String v) throws ToolsException {
        this.setEscapeUriAttributes(this.parseBoolean(v));
    }

    public Double getHtmlVersion() {
        return this.myHtmlVersion;
    }

    public void setHtmlVersion(Double v) {
        this.myHtmlVersion = v;
    }

    public void setHtmlVersion(String v) throws ToolsException {
        this.setHtmlVersion(this.parseDecimal(v));
    }

    public Boolean getIncludeContentType() {
        return this.myIncludeContentType;
    }

    public void setIncludeContentType(Boolean v) {
        this.myIncludeContentType = v;
    }

    public void setIncludeContentType(String v) throws ToolsException {
        this.setIncludeContentType(this.parseBoolean(v));
    }

    public Boolean getIndent() {
        return this.myIndent;
    }

    public void setIndent(Boolean v) {
        this.myIndent = v;
    }

    public void setIndent(String v) throws ToolsException {
        this.setIndent(this.parseBoolean(v));
    }

    public String getItemSeparator() {
        return this.myItemSeparator;
    }

    public void setItemSeparator(String v) {
        this.myItemSeparator = v;
    }

    public String getMediaType() {
        return this.myMediaType;
    }

    public void setMediaType(String v) {
        this.myMediaType = v;
    }

    public QName getMethod() {
        return this.myMethod;
    }

    public void setMethod(QName v) {
        this.myMethod = v;
    }

    public String getNormalizationForm() {
        return this.myNormalizationForm;
    }

    public void setNormalizationForm(String v) {
        this.myNormalizationForm = v;
    }

    public Boolean getOmitXmlDeclaration() {
        return this.myOmitXmlDeclaration;
    }

    public void setOmitXmlDeclaration(Boolean v) {
        this.myOmitXmlDeclaration = v;
    }

    public void setOmitXmlDeclaration(String v) throws ToolsException {
        this.setOmitXmlDeclaration(this.parseBoolean(v));
    }

    public Standalone getStandalone() {
        return this.myStandalone;
    }

    public void setStandalone(Standalone v) {
        this.myStandalone = v;
    }

    public void setStandalone(String v) throws ToolsException {
        this.setStandalone(this.parseStandalone(v));
    }

    public Iterable<QName> getSuppressIndentation() {
        return this.mySuppressIndentation;
    }

    public void setSuppressIndentation(Iterable<QName> v) {
        this.mySuppressIndentation = new HashSet<QName>();
        for (QName q : v) {
            this.mySuppressIndentation.add(q);
        }
    }

    public void setSuppressIndentation(String v, Element scope) throws ToolsException {
        this.mySuppressIndentation = this.parseQNames(v, scope);
    }

    public Boolean getUndeclarePrefixes() {
        return this.myUndeclarePrefixes;
    }

    public void setUndeclarePrefixes(Boolean v) {
        this.myUndeclarePrefixes = v;
    }

    public void setUndeclarePrefixes(String v) throws ToolsException {
        this.setUndeclarePrefixes(this.parseBoolean(v));
    }

    public Iterable<UseChar> getUseCharacterMaps() {
        return this.myUseCharacterMaps;
    }

    public void setUseCharacterMaps(Iterable<UseChar> v) {
        this.myUseCharacterMaps = new HashSet<UseChar>();
        for (UseChar q : v) {
            this.myUseCharacterMaps.add(q);
        }
    }

    public void setUseCharacterMaps(String v, Element scope) throws ToolsException {
        this.myUseCharacterMaps = this.parseCharMap(v, scope);
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String v) {
        this.myVersion = v;
    }

    private Boolean parseBoolean(String value) throws ToolsException {
        if ("yes".equals(value)) {
            return Boolean.TRUE;
        }
        if ("no".equals(value)) {
            return Boolean.FALSE;
        }
        throw new ToolsException("Invalid yes/no value: " + value);
    }

    private Standalone parseStandalone(String value) throws ToolsException {
        if ("yes".equals(value)) {
            return Standalone.YES;
        }
        if ("no".equals(value)) {
            return Standalone.NO;
        }
        if ("omit".equals(value)) {
            return Standalone.OMIT;
        }
        throw new ToolsException("Invalid standalone (yes/no/omit) value: " + value);
    }

    private Double parseDecimal(String value) throws ToolsException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new ToolsException("Error parsing a decimal serialization parameter: " + value, ex);
        }
    }

    private Set<QName> parseQNames(String value, Element scope) throws ToolsException {
        HashSet<QName> qnames = new HashSet<QName>();
        for (String v : value.split("\\s+")) {
            qnames.add(scope.parseQName(v));
        }
        return qnames;
    }

    private Set<UseChar> parseCharMap(String value, Element scope) throws ToolsException {
        HashSet<UseChar> result = new HashSet<UseChar>();
        for (Element elem : scope.children()) {
            String ns = elem.getNamespaceUri();
            String name = elem.getLocalName();
            if (!SERIAL_NS_URI.equals(ns) || !CHAR_MAP_NAME.equals(name)) {
                throw new ToolsException("Element name incorrect: {" + ns + "}" + name);
            }
            String ch = elem.getAttribute(CHAR_ATTR_NAME);
            String str = elem.getAttribute(MAP_STRING_ATTR_NAME);
            UseChar us = new UseChar(ch, str);
            result.add(us);
        }
        return result;
    }

    public class UseChar {
        public String character;
        public String stringMap;

        public UseChar(String c, String s) {
            this.character = c;
            this.stringMap = s;
        }
    }

    public static enum Standalone {
        YES,
        NO,
        OMIT;

    }
}

