/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.attributes;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAttributeList
implements AttributeList {
    public static final int XMLNS_PFX_START = "xmlns".length() + 1;
    protected boolean preserveSchemaLocation;
    protected boolean preservePrefixes;
    protected boolean hasXsiType;
    protected String xsiTypeRaw;
    protected String xsiTypePrefix;
    protected boolean hasXsiNil;
    protected String xsiNil;
    protected String xsiNilPrefix;
    protected List<String> attributeURI;
    protected List<String> attributeLocalName;
    protected List<String> attributeValue;
    protected List<String> attributePrefix;
    protected List<NamespaceDeclaration> nsDecls;

    public AbstractAttributeList(EXIFactory exiFactory) {
        this.preserveSchemaLocation = exiFactory.getEncodingOptions().isOptionEnabled("INCLUDE_XSI_SCHEMALOCATION");
        this.preservePrefixes = exiFactory.getFidelityOptions().isFidelityEnabled("PRESERVE_PREFIXES");
        this.attributeURI = new ArrayList<String>();
        this.attributeLocalName = new ArrayList<String>();
        this.attributeValue = new ArrayList<String>();
        this.attributePrefix = new ArrayList<String>();
        this.nsDecls = new ArrayList<NamespaceDeclaration>();
    }

    public void clear() {
        this.hasXsiType = false;
        this.hasXsiNil = false;
        this.attributeURI.clear();
        this.attributeLocalName.clear();
        this.attributeValue.clear();
        this.attributePrefix.clear();
        this.xsiTypeRaw = null;
        this.nsDecls.clear();
    }

    public boolean hasXsiType() {
        return this.hasXsiType;
    }

    public String getXsiTypeRaw() {
        return this.xsiTypeRaw;
    }

    public String getXsiTypePrefix() {
        return this.xsiTypePrefix;
    }

    public boolean hasXsiNil() {
        return this.hasXsiNil;
    }

    public String getXsiNil() {
        return this.xsiNil;
    }

    public String getXsiNilPrefix() {
        return this.xsiNilPrefix;
    }

    public int getNumberOfAttributes() {
        return this.attributeURI.size();
    }

    public String getAttributeURI(int index) {
        return this.attributeURI.get(index);
    }

    public String getAttributeLocalName(int index) {
        return this.attributeLocalName.get(index);
    }

    public String getAttributeValue(int index) {
        return this.attributeValue.get(index);
    }

    public String getAttributePrefix(int index) {
        return this.attributePrefix.get(index);
    }

    private void setXsiType(String rawType, String xsiPrefix) {
        this.hasXsiType = true;
        this.xsiTypeRaw = rawType;
        this.xsiTypePrefix = xsiPrefix;
    }

    private void setXsiNil(String rawNil, String xsiPrefix) {
        this.hasXsiNil = true;
        this.xsiNil = rawNil;
        this.xsiNilPrefix = xsiPrefix;
    }

    public void addNamespaceDeclaration(String uri, String pfx) {
        this.nsDecls.add(new NamespaceDeclaration(uri, pfx));
    }

    public int getNumberOfNamespaceDeclarations() {
        return this.nsDecls.size();
    }

    public NamespaceDeclaration getNamespaceDeclaration(int index) {
        assert (index >= 0 && index < this.nsDecls.size());
        return this.nsDecls.get(index);
    }

    public void addAttribute(String uri, String localName, String pfx, String value) {
        uri = uri == null ? "" : uri;
        String string = pfx = pfx == null ? "" : pfx;
        if (uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            if (localName.equals("type")) {
                this.setXsiType(value, pfx);
            } else if (localName.equals("nil")) {
                this.setXsiNil(value, pfx);
            } else if (!localName.equals("schemaLocation") && !localName.equals("noNamespaceSchemaLocation") || this.preserveSchemaLocation) {
                this.insertAttribute(uri, localName, pfx, value);
            }
        } else {
            this.insertAttribute(uri, localName, pfx, value);
        }
    }

    protected abstract void insertAttribute(String var1, String var2, String var3, String var4);
}

