/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.DatatypeID;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;

public class BooleanFacetDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = 3601744720431415L;
    private final BooleanValue bv0 = new BooleanValue(0);
    private final BooleanValue bv1 = new BooleanValue(1);
    private final BooleanValue bv2 = new BooleanValue(2);
    private final BooleanValue bv3 = new BooleanValue(3);
    private int lastValidBooleanID;
    private boolean lastValidBoolean;

    public BooleanFacetDatatype(QNameContext schemaType) {
        super(BuiltInType.BOOLEAN_FACET, schemaType);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_boolean;
    }

    protected boolean isValidString(String value) {
        value = value.trim();
        boolean retValue = true;
        if (value.equals("false")) {
            this.lastValidBooleanID = 0;
            this.lastValidBoolean = false;
        } else if (value.equals("0")) {
            this.lastValidBooleanID = 1;
            this.lastValidBoolean = false;
        } else if (value.equals("true")) {
            this.lastValidBooleanID = 2;
            this.lastValidBoolean = true;
        } else if (value.equals("1")) {
            this.lastValidBooleanID = 3;
            this.lastValidBoolean = true;
        } else {
            retValue = false;
        }
        return retValue;
    }

    public boolean isValid(Value value) {
        if (value instanceof BooleanValue) {
            this.lastValidBoolean = ((BooleanValue)value).toBoolean();
            this.lastValidBooleanID = this.lastValidBoolean ? 2 : 0;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastValidBooleanID, 2);
    }

    public Value readValue(QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        BooleanValue bv;
        int booleanID = valueChannel.decodeNBitUnsignedInteger(2);
        switch (booleanID) {
            case 0: {
                bv = this.bv0;
                break;
            }
            case 1: {
                bv = this.bv1;
                break;
            }
            case 2: {
                bv = this.bv2;
                break;
            }
            case 3: {
                bv = this.bv3;
                break;
            }
            default: {
                throw new RuntimeException("Error while decoding boolean pattern facet");
            }
        }
        return bv;
    }
}

