/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.helpers;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.DecodingOptions;
import com.siemens.ct.exi.EXIBodyDecoder;
import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EncodingOptions;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.SchemaIdResolver;
import com.siemens.ct.exi.api.sax.SAXDecoder;
import com.siemens.ct.exi.api.sax.SAXEncoder;
import com.siemens.ct.exi.api.sax.SAXEncoderExtendedHandler;
import com.siemens.ct.exi.core.EXIBodyDecoderInOrder;
import com.siemens.ct.exi.core.EXIBodyDecoderInOrderSC;
import com.siemens.ct.exi.core.EXIBodyDecoderReordered;
import com.siemens.ct.exi.core.EXIBodyEncoderInOrder;
import com.siemens.ct.exi.core.EXIBodyEncoderInOrderSC;
import com.siemens.ct.exi.core.EXIBodyEncoderReordered;
import com.siemens.ct.exi.datatype.strings.BoundedStringDecoderImpl;
import com.siemens.ct.exi.datatype.strings.BoundedStringEncoderImpl;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringDecoderImpl;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.grammars.SchemaLessGrammars;
import com.siemens.ct.exi.helpers.DefaultSchemaIdResolver;
import com.siemens.ct.exi.types.AbstractTypeDecoder;
import com.siemens.ct.exi.types.AbstractTypeEncoder;
import com.siemens.ct.exi.types.LexicalTypeDecoder;
import com.siemens.ct.exi.types.LexicalTypeEncoder;
import com.siemens.ct.exi.types.StringTypeDecoder;
import com.siemens.ct.exi.types.StringTypeEncoder;
import com.siemens.ct.exi.types.TypeDecoder;
import com.siemens.ct.exi.types.TypeEncoder;
import com.siemens.ct.exi.types.TypedTypeDecoder;
import com.siemens.ct.exi.types.TypedTypeEncoder;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.xml.sax.XMLReader;

public class DefaultEXIFactory
implements EXIFactory {
    protected Grammars grammar;
    protected boolean isFragment;
    protected CodingMode codingMode;
    protected FidelityOptions fidelityOptions;
    protected EncodingOptions encodingOptions;
    protected DecodingOptions decodingOptions;
    protected SchemaIdResolver schemaIdResolver;
    protected QName[] dtrMapTypes;
    protected QName[] dtrMapRepresentations;
    protected QName[] scElements;
    protected int blockSize = 1000000;
    protected int valueMaxLength = -1;
    protected int valuePartitionCapacity = -1;
    protected boolean localValuePartitions = true;
    protected int maximumNumberOfBuiltInElementGrammars = -1;
    protected int maximumNumberOfBuiltInProductions = -1;
    protected boolean grammarLearningDisabled = false;
    protected EXIBodyEncoder bodyEncoder;
    protected EXIBodyDecoder bodyDecoder;

    protected DefaultEXIFactory() {
    }

    protected static void setDefaultValues(EXIFactory factory) {
        factory.setFidelityOptions(FidelityOptions.createDefault());
        factory.setEncodingOptions(EncodingOptions.createDefault());
        factory.setDecodingOptions(DecodingOptions.createDefault());
        factory.setCodingMode(CodingMode.BIT_PACKED);
        factory.setFragment(false);
        factory.setGrammars(new SchemaLessGrammars());
        factory.setSchemaIdResolver(new DefaultSchemaIdResolver());
    }

    public static EXIFactory newInstance() {
        DefaultEXIFactory factory = new DefaultEXIFactory();
        DefaultEXIFactory.setDefaultValues(factory);
        return factory;
    }

    public void setFidelityOptions(FidelityOptions fidelityOptions) {
        this.fidelityOptions = fidelityOptions;
    }

    public FidelityOptions getFidelityOptions() {
        return this.fidelityOptions;
    }

    public void setEncodingOptions(EncodingOptions encodingOptions) {
        this.encodingOptions = encodingOptions;
    }

    public EncodingOptions getEncodingOptions() {
        return this.encodingOptions;
    }

    public void setDecodingOptions(DecodingOptions decodingOptions) {
        this.decodingOptions = decodingOptions;
    }

    public DecodingOptions getDecodingOptions() {
        return this.decodingOptions;
    }

    public void setSchemaIdResolver(SchemaIdResolver schemaIdResolver) {
        this.schemaIdResolver = schemaIdResolver;
    }

    public SchemaIdResolver getSchemaIdResolver() {
        return this.schemaIdResolver;
    }

    public void setDatatypeRepresentationMap(QName[] dtrMapTypes, QName[] dtrMapRepresentations) {
        if (dtrMapTypes == null || dtrMapRepresentations == null || dtrMapTypes.length != dtrMapRepresentations.length || dtrMapTypes.length == 0) {
            this.dtrMapTypes = null;
            this.dtrMapRepresentations = null;
        } else {
            this.dtrMapTypes = dtrMapTypes;
            this.dtrMapRepresentations = dtrMapRepresentations;
        }
    }

    public QName[] getDatatypeRepresentationMapTypes() {
        return this.dtrMapTypes;
    }

    public QName[] getDatatypeRepresentationMapRepresentations() {
        return this.dtrMapRepresentations;
    }

    public void setSelfContainedElements(QName[] scElements) {
        this.scElements = scElements;
    }

    public boolean isSelfContainedElement(QName element) {
        if (this.scElements != null && this.scElements.length > 0) {
            for (QName qname : this.scElements) {
                if (!qname.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public void setGrammars(Grammars grammar) {
        assert (grammar != null);
        this.grammar = grammar;
    }

    public Grammars getGrammars() {
        return this.grammar;
    }

    protected boolean isSchemaInformed() {
        return this.grammar.isSchemaInformed();
    }

    public void setFragment(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public void setCodingMode(CodingMode codingMode) {
        this.codingMode = codingMode;
    }

    public CodingMode getCodingMode() {
        return this.codingMode;
    }

    public void setBlockSize(int blockSize) {
        if (blockSize < 0) {
            throw new RuntimeException("EXI's blockSize has the be a positive number!");
        }
        this.blockSize = blockSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setValueMaxLength(int valueMaxLength) {
        this.valueMaxLength = valueMaxLength;
    }

    public int getValueMaxLength() {
        return this.valueMaxLength;
    }

    public void setValuePartitionCapacity(int valuePartitionCapacity) {
        this.valuePartitionCapacity = valuePartitionCapacity;
    }

    public int getValuePartitionCapacity() {
        return this.valuePartitionCapacity;
    }

    public void setLocalValuePartitions(boolean useLocalValuePartitions) {
        this.localValuePartitions = useLocalValuePartitions;
    }

    public boolean isLocalValuePartitions() {
        return this.localValuePartitions;
    }

    public void setMaximumNumberOfBuiltInElementGrammars(int maximumNumberOfBuiltInElementGrammars) {
        this.maximumNumberOfBuiltInElementGrammars = maximumNumberOfBuiltInElementGrammars >= 0 ? maximumNumberOfBuiltInElementGrammars : -1;
        this.checkGrammarLearningDisabled();
    }

    public int getMaximumNumberOfBuiltInElementGrammars() {
        return this.maximumNumberOfBuiltInElementGrammars;
    }

    public void setMaximumNumberOfBuiltInProductions(int maximumNumberOfBuiltInProductions) {
        this.maximumNumberOfBuiltInProductions = maximumNumberOfBuiltInProductions >= 0 ? maximumNumberOfBuiltInProductions : -1;
        this.checkGrammarLearningDisabled();
    }

    public int getMaximumNumberOfBuiltInProductions() {
        return this.maximumNumberOfBuiltInProductions;
    }

    private void checkGrammarLearningDisabled() {
        this.grammarLearningDisabled = this.maximumNumberOfBuiltInElementGrammars >= 0 || this.maximumNumberOfBuiltInProductions >= 0;
    }

    public boolean isGrammarLearningDisabled() {
        return this.grammarLearningDisabled;
    }

    protected void doSanityCheck() throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED") && this.codingMode.usesRechanneling()) {
            throw new EXIException("(Pre-)Compression and selfContained elements cannot work together");
        }
        if (!this.grammar.isSchemaInformed()) {
            this.maximumNumberOfBuiltInElementGrammars = -1;
            this.maximumNumberOfBuiltInProductions = -1;
            this.grammarLearningDisabled = false;
        }
    }

    public void setEXIBodyEncoder(String className) throws EXIException {
        try {
            ClassLoader classLoader = DefaultEXIFactory.class.getClassLoader();
            Class<?> aClass = classLoader.loadClass(className);
            Object aObject = aClass.newInstance();
            if (!EXIBodyEncoder.class.isInstance(aObject)) {
                throw new EXIException("Class does not implemement " + EXIBodyEncoder.class);
            }
            this.setEXIBodyEncoder((EXIBodyEncoder)aObject);
        }
        catch (ClassNotFoundException e) {
            throw new EXIException(e);
        }
        catch (InstantiationException e) {
            throw new EXIException(e);
        }
        catch (IllegalAccessException e) {
            throw new EXIException(e);
        }
    }

    public void setEXIBodyEncoder(EXIBodyEncoder bodyEncoder) throws EXIException {
        this.bodyEncoder = bodyEncoder;
    }

    public void setEXIBodyDecoder(String className) throws EXIException {
        try {
            ClassLoader classLoader = DefaultEXIFactory.class.getClassLoader();
            Class<?> aClass = classLoader.loadClass(className);
            Object aObject = aClass.newInstance();
            if (!EXIBodyDecoder.class.isInstance(aObject)) {
                throw new EXIException("Class does not implemement " + EXIBodyDecoder.class);
            }
            this.setEXIBodyDecoder((EXIBodyDecoder)aObject);
        }
        catch (ClassNotFoundException e) {
            throw new EXIException(e);
        }
        catch (InstantiationException e) {
            throw new EXIException(e);
        }
        catch (IllegalAccessException e) {
            throw new EXIException(e);
        }
    }

    public void setEXIBodyDecoder(EXIBodyDecoder bodyDecoder) throws EXIException {
        this.bodyDecoder = bodyDecoder;
    }

    public EXIBodyEncoder createEXIBodyEncoder() throws EXIException {
        if (this.bodyEncoder != null) {
            return this.bodyEncoder;
        }
        this.doSanityCheck();
        if (this.codingMode.usesRechanneling()) {
            return new EXIBodyEncoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIBodyEncoderInOrderSC(this);
        }
        return new EXIBodyEncoderInOrder(this);
    }

    public SAXEncoder createEXIWriter() throws EXIException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") || this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_PIS") || this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXEncoderExtendedHandler(this);
        }
        return new SAXEncoder(this);
    }

    public EXIBodyDecoder createEXIBodyDecoder() throws EXIException {
        if (this.bodyDecoder != null) {
            return this.bodyDecoder;
        }
        this.doSanityCheck();
        if (this.codingMode.usesRechanneling()) {
            return new EXIBodyDecoderReordered(this);
        }
        if (this.fidelityOptions.isFidelityEnabled("SELF_CONTAINED")) {
            return new EXIBodyDecoderInOrderSC(this);
        }
        return new EXIBodyDecoderInOrder(this);
    }

    public XMLReader createEXIReader() throws EXIException {
        return new SAXDecoder(this);
    }

    public StringEncoder createStringEncoder() {
        StringEncoderImpl stringEncoder = this.getValueMaxLength() != -1 || this.getValuePartitionCapacity() != -1 ? new BoundedStringEncoderImpl(this.isLocalValuePartitions(), this.getValueMaxLength(), this.getValuePartitionCapacity()) : new StringEncoderImpl(this.isLocalValuePartitions());
        return stringEncoder;
    }

    public StringDecoder createStringDecoder() {
        StringDecoderImpl stringDecoder = this.getValueMaxLength() != -1 || this.getValuePartitionCapacity() != -1 ? new BoundedStringDecoderImpl(this.isLocalValuePartitions(), this.getValueMaxLength(), this.getValuePartitionCapacity()) : new StringDecoderImpl(this.isLocalValuePartitions());
        return stringDecoder;
    }

    public TypeEncoder createTypeEncoder() throws EXIException {
        AbstractTypeEncoder typeEncoder;
        if (this.isSchemaInformed()) {
            this.checkDtrMap();
            typeEncoder = this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES") ? new LexicalTypeEncoder(this.dtrMapTypes, this.dtrMapRepresentations) : new TypedTypeEncoder(this.dtrMapTypes, this.dtrMapRepresentations);
        } else {
            typeEncoder = new StringTypeEncoder();
        }
        return typeEncoder;
    }

    private void checkDtrMap() throws EXIException {
        if (this.dtrMapTypes == null) {
            this.dtrMapRepresentations = null;
        } else if (this.dtrMapRepresentations == null || this.dtrMapTypes.length != this.dtrMapRepresentations.length) {
            throw new EXIException("Number of arguments for DTR map must match.");
        }
    }

    public TypeDecoder createTypeDecoder() throws EXIException {
        AbstractTypeDecoder typeDecoder;
        if (this.isSchemaInformed()) {
            this.checkDtrMap();
            typeDecoder = this.fidelityOptions.isFidelityEnabled("PRESERVE_LEXICAL_VALUES") ? new LexicalTypeDecoder(this.dtrMapTypes, this.dtrMapRepresentations) : new TypedTypeDecoder(this.dtrMapTypes, this.dtrMapRepresentations);
        } else {
            typeDecoder = new StringTypeDecoder();
        }
        return typeDecoder;
    }

    public EXIFactory clone() {
        try {
            EXIFactory copy = (EXIFactory)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof EXIFactory) {
            EXIFactory other = (EXIFactory)o;
            if (!this.fidelityOptions.equals(other.getFidelityOptions())) {
                return false;
            }
            if (this.isFragment != other.isFragment()) {
                return false;
            }
            if (!Arrays.equals(this.dtrMapTypes, other.getDatatypeRepresentationMapTypes()) || !Arrays.equals(this.dtrMapRepresentations, other.getDatatypeRepresentationMapRepresentations())) {
                return false;
            }
            if (this.getCodingMode() != other.getCodingMode()) {
                return false;
            }
            if (this.getBlockSize() != other.getBlockSize()) {
                return false;
            }
            if (this.getValueMaxLength() != other.getValueMaxLength()) {
                return false;
            }
            return this.getValuePartitionCapacity() == other.getValuePartitionCapacity();
        }
        return false;
    }

    public int hashCode() {
        return this.fidelityOptions.hashCode() ^ (this.isFragment ? 1 : 0) ^ this.codingMode.hashCode() ^ this.blockSize ^ this.valueMaxLength ^ this.valuePartitionCapacity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.grammar.isSchemaInformed()) {
            SchemaInformedGrammars sig = (SchemaInformedGrammars)this.grammar;
            sb.append("[Schema-Informed=" + sig.getSchemaId() + "]");
        } else {
            sb.append("[Schema-Less]");
        }
        sb.append("[" + (Object)((Object)this.codingMode) + "]");
        sb.append(this.fidelityOptions.toString());
        if (this.isFragment()) {
            sb.append("[Fragment]");
        }
        if (this.dtrMapTypes != null && this.dtrMapTypes.length > 0) {
            sb.append("[DTR Types=");
            for (QName dtrMapType : this.dtrMapTypes) {
                sb.append(dtrMapType + " ");
            }
            sb.append(", Representation=");
            for (QName dtrMapRepresentation : this.dtrMapRepresentations) {
                sb.append(dtrMapRepresentation + " ");
            }
            sb.append("]");
        }
        if (this.scElements != null && this.scElements.length > 0) {
            sb.append("[SCElements=");
            for (QName scElement : this.scElements) {
                sb.append(scElement + " ");
            }
            sb.append("]");
        }
        if (this.blockSize != 1000000) {
            sb.append("[blockSize=" + this.blockSize + "]");
        }
        if (this.valueMaxLength != -1) {
            sb.append("[valueMaxLength=" + this.valueMaxLength + "]");
        }
        if (this.valuePartitionCapacity != -1) {
            sb.append("[valuePartitionCapacity=" + this.valuePartitionCapacity + "]");
        }
        if (!this.isLocalValuePartitions()) {
            sb.append("[localValuePartitions=" + this.isLocalValuePartitions() + "]");
        }
        if (this.getMaximumNumberOfBuiltInProductions() >= 0) {
            sb.append("[maximumNumberOfBuiltInProductions=" + this.getMaximumNumberOfBuiltInProductions() + "]");
        }
        if (this.getMaximumNumberOfBuiltInElementGrammars() >= 0) {
            sb.append("[maximumNumberOfEvolvingBuiltInElementGrammars=" + this.getMaximumNumberOfBuiltInElementGrammars() + "]");
        }
        return sb.toString();
    }
}

