/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.component.initialize;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.propertyeditors.PropertyEditorUtil;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Logger;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.ObjectError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationParameterInitializer {
    private ConfigurationParameterInitializer() {
    }

    public static void initialize(Object component, UimaContext context) throws ResourceInitializationException {
        MutablePropertyValues values = new MutablePropertyValues();
        ArrayList<String> mandatoryValues = new ArrayList<String>();
        for (Field field : ReflectionUtil.getFields(component)) {
            if (!ConfigurationParameterFactory.isConfigurationParameterField(field)) continue;
            ConfigurationParameter annotation = ReflectionUtil.getAnnotation(field, ConfigurationParameter.class);
            String parameterName = ConfigurationParameterFactory.getConfigurationParameterName(field);
            Object parameterValue = context.getConfigParameterValue(parameterName);
            if (parameterValue == null) {
                parameterValue = ConfigurationParameterFactory.getDefaultValue(field);
            }
            if (parameterValue != null) {
                values.addPropertyValue(field.getName(), parameterValue);
            }
            if (!annotation.mandatory()) continue;
            mandatoryValues.add(field.getName());
        }
        DataBinder binder = new DataBinder(component){

            protected void checkRequiredFields(MutablePropertyValues mpvs) {
                Object[] requiredFields = this.getRequiredFields();
                if (!ObjectUtils.isEmpty((Object[])requiredFields)) {
                    PropertyValue[] pvs;
                    HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
                    for (PropertyValue propertyValue : pvs = mpvs.getPropertyValues()) {
                        String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)propertyValue.getName());
                        propertyValues.put(canonicalName, propertyValue);
                    }
                    for (Object object : requiredFields) {
                        boolean empty;
                        PropertyValue pv = (PropertyValue)propertyValues.get(object);
                        boolean bl = empty = pv == null || pv.getValue() == null;
                        if (!empty) continue;
                        this.getBindingErrorProcessor().processMissingFieldError((String)object, (BindingResult)this.getInternalBindingResult());
                        if (pv == null) continue;
                        mpvs.removePropertyValue(pv);
                        propertyValues.remove(object);
                    }
                }
            }
        };
        binder.initDirectFieldAccess();
        PropertyEditorUtil.registerUimaFITEditors((PropertyEditorRegistry)binder);
        binder.setRequiredFields(mandatoryValues.toArray(new String[mandatoryValues.size()]));
        binder.bind((PropertyValues)values);
        if (binder.getBindingResult().hasErrors()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Errors initializing [" + component.getClass() + "]");
            for (ObjectError error : binder.getBindingResult().getAllErrors()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(error.getDefaultMessage());
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void initialize(Object component, Map<String, Object> map) throws ResourceInitializationException {
        UimaContextAdmin context = UIMAFramework.newUimaContext((Logger)UIMAFramework.getLogger(), (ResourceManager)UIMAFramework.newDefaultResourceManager(), (ConfigurationManager)UIMAFramework.newConfigurationManager());
        ConfigurationManager cfgMgr = context.getConfigurationManager();
        cfgMgr.setSession(context.getSession());
        for (Map.Entry<String, Object> e : map.entrySet()) {
            cfgMgr.setConfigParameterValue(context.getQualifiedContextName() + e.getKey(), e.getValue());
        }
        ConfigurationParameterInitializer.initialize(component, (UimaContext)context);
    }

    public static void initialize(Object component, ResourceSpecifier spec) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize(component, ConfigurationParameterFactory.getParameterSettings(spec));
    }

    public static void initialize(Object component, Parameter ... parameters) throws ResourceInitializationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Parameter p : parameters) {
            params.put(p.getName(), p.getValue());
        }
        ConfigurationParameterInitializer.initialize(component, params);
    }

    public static void initialize(Object component, NameValuePair ... parameters) throws ResourceInitializationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (NameValuePair p : parameters) {
            params.put(p.getName(), p.getValue());
        }
        ConfigurationParameterInitializer.initialize(component, params);
    }

    public static void initialize(Object component, DataResource dataResource) throws ResourceInitializationException {
        ResourceMetaData metaData = dataResource.getMetaData();
        ConfigurationParameterSettings settings = metaData.getConfigurationParameterSettings();
        ConfigurationParameterInitializer.initialize(component, settings.getParameterSettings());
    }
}

