/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.serialization.annotation;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.serialization.annotation.AbstractSingleValueSerializationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationErrorCodes;

public class EncodingAnnotation
extends AbstractSingleValueSerializationAnnotation {
    private static final Pattern ptnEncoding = Pattern.compile("[a-zA-Z0-9\\-]+");

    @Override
    protected boolean validate(String value) {
        Matcher mtcEncoding = ptnEncoding.matcher(value);
        return mtcEncoding.matches() && Charset.isSupported(value);
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getTooManyLiteralsErr() {
        return SerializationAnnotationErrorCodes.SEST0013;
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getEmptyAnnotationParamsErr() {
        return SerializationAnnotationErrorCodes.SEST0014;
    }

    @Override
    protected SerializationAnnotationErrorCodes.SerializationAnnotationErrorCode getInvalidValueErr() {
        return SerializationAnnotationErrorCodes.SEST0015;
    }
}

