/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.StringUtils;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.http11.auth.BasicAuthHandler;
import com.bradmcevoy.http.http11.auth.DigestAuthenticationHandler;
import com.bradmcevoy.http.http11.auth.ExpiredNonceRemover;
import com.bradmcevoy.http.http11.auth.Nonce;
import com.bradmcevoy.http.http11.auth.NonceProvider;
import com.bradmcevoy.http.http11.auth.SimpleMemoryNonceProvider;
import com.ettrema.sso.ExternalIdentityProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationService.class);
    private List<AuthenticationHandler> authenticationHandlers;
    private List<AuthenticationHandler> extraHandlers;
    private List<AuthenticationHandler> allHandlers;
    private boolean disableBasic;
    private boolean disableDigest;
    private List<ExternalIdentityProvider> externalIdentityProviders;
    private boolean disableExternal;
    private String[] browserIds = new String[]{"msie", "firefox", "chrome", "safari", "opera"};

    public AuthenticationService(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
        this.setAllHandlers();
    }

    public AuthenticationService(NonceProvider nonceProvider) {
        DigestAuthenticationHandler digest = new DigestAuthenticationHandler(nonceProvider);
        BasicAuthHandler basic = new BasicAuthHandler();
        this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
        this.authenticationHandlers.add(basic);
        this.authenticationHandlers.add(digest);
        this.setAllHandlers();
    }

    public AuthenticationService() {
        ConcurrentHashMap<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
        int nonceValiditySeconds = 86400;
        ExpiredNonceRemover expiredNonceRemover = new ExpiredNonceRemover(nonces, nonceValiditySeconds);
        SimpleMemoryNonceProvider nonceProvider = new SimpleMemoryNonceProvider(nonceValiditySeconds, expiredNonceRemover, nonces);
        DigestAuthenticationHandler digest = new DigestAuthenticationHandler(nonceProvider);
        BasicAuthHandler basic = new BasicAuthHandler();
        this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
        this.authenticationHandlers.add(basic);
        this.authenticationHandlers.add(digest);
        this.setAllHandlers();
        expiredNonceRemover.start();
    }

    public void setDisableBasic(boolean b) {
        if (b) {
            Iterator<AuthenticationHandler> it = this.authenticationHandlers.iterator();
            while (it.hasNext()) {
                AuthenticationHandler hnd = it.next();
                if (!(hnd instanceof BasicAuthHandler)) continue;
                it.remove();
            }
        }
        this.disableBasic = b;
        this.setAllHandlers();
    }

    public boolean isDisableBasic() {
        return this.disableBasic;
    }

    public void setDisableDigest(boolean b) {
        if (b) {
            Iterator<AuthenticationHandler> it = this.authenticationHandlers.iterator();
            while (it.hasNext()) {
                AuthenticationHandler hnd = it.next();
                if (!(hnd instanceof DigestAuthenticationHandler)) continue;
                it.remove();
            }
        }
        this.disableDigest = b;
        this.setAllHandlers();
    }

    public boolean isDisableDigest() {
        return this.disableDigest;
    }

    public AuthStatus authenticate(Resource resource, Request request) {
        boolean preAuthenticated;
        log.trace("authenticate");
        Auth auth = request.getAuthorization();
        boolean bl = preAuthenticated = auth != null && auth.getTag() != null;
        if (preAuthenticated) {
            log.trace("request is pre-authenticated");
            return new AuthStatus(auth, false);
        }
        for (AuthenticationHandler h : this.allHandlers) {
            if (h.supports(resource, request)) {
                Object loginToken = h.authenticate(resource, request);
                if (loginToken == null) {
                    log.warn("authentication failed by AuthenticationHandler:" + h.getClass());
                    return new AuthStatus(auth, true);
                }
                if (log.isTraceEnabled()) {
                    log.trace("authentication passed by: " + h.getClass());
                }
                if (auth == null) {
                    auth = new Auth(Auth.Scheme.FORM, null, loginToken);
                    request.setAuthorization(auth);
                }
                auth.setTag(loginToken);
                return new AuthStatus(auth, false);
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("handler does not support this resource and request. handler: " + h.getClass() + " resource: " + resource.getClass());
        }
        log.trace("authentication did not locate a user, because no handler accepted the request");
        return null;
    }

    public List<String> getChallenges(Resource resource, Request request) {
        ArrayList<String> challenges = new ArrayList<String>();
        for (AuthenticationHandler h : this.allHandlers) {
            if (h.isCompatible(resource)) {
                log.debug("challenge for auth: " + h.getClass());
                String ch = h.getChallenge(resource, request);
                if (ch == null) continue;
                challenges.add(ch);
                continue;
            }
            log.debug("not challenging for auth: " + h.getClass() + " for resource type: " + (resource == null ? "" : resource.getClass()));
        }
        return challenges;
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.allHandlers;
    }

    public List<AuthenticationHandler> getExtraHandlers() {
        return this.extraHandlers;
    }

    public void setExtraHandlers(List<AuthenticationHandler> extraHandlers) {
        this.extraHandlers = extraHandlers;
        this.setAllHandlers();
    }

    public List<ExternalIdentityProvider> getExternalIdentityProviders() {
        return this.externalIdentityProviders;
    }

    public void setExternalIdentityProviders(List<ExternalIdentityProvider> externalIdentityProviders) {
        this.externalIdentityProviders = externalIdentityProviders;
    }

    public boolean isDisableExternal() {
        return this.disableExternal;
    }

    public void setDisableExternal(boolean disableExternal) {
        this.disableExternal = disableExternal;
    }

    private void setAllHandlers() {
        ArrayList<AuthenticationHandler> handlers = new ArrayList<AuthenticationHandler>();
        if (this.authenticationHandlers != null) {
            handlers.addAll(this.authenticationHandlers);
        }
        if (this.extraHandlers != null) {
            handlers.addAll(this.extraHandlers);
        }
        this.allHandlers = Collections.unmodifiableList(handlers);
    }

    public boolean canUseExternalAuth(Resource resource, Request request) {
        if (this.isDisableExternal()) {
            log.trace("auth svc has disabled external auth");
            return false;
        }
        if (this.getExternalIdentityProviders() == null || this.getExternalIdentityProviders().isEmpty()) {
            log.trace("auth service has no external auth providers");
            return false;
        }
        if (resource instanceof GetableResource) {
            GetableResource gr = (GetableResource)resource;
            String ct = gr.getContentType("text/html");
            if (ct == null || !ct.contains("html")) {
                log.trace("is not of content type html");
                return false;
            }
        } else {
            log.trace("is not getable");
            return false;
        }
        String ua = request.getUserAgentHeader();
        if (StringUtils.contains(ua.toLowerCase(), this.browserIds)) {
            log.trace("is a known web browser, so can offer external auth");
            return true;
        }
        log.trace("not a known web browser, so cannot offer external auth");
        return false;
    }

    public static class AuthStatus {
        public final Auth auth;
        public final boolean loginFailed;

        public AuthStatus(Auth auth, boolean loginFailed) {
            this.auth = auth;
            this.loginFailed = loginFailed;
        }
    }
}

