/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.DeletableCollectionResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.DeleteHelper;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.ettrema.event.DeleteEvent;
import com.ettrema.event.EventManager;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHelperImpl
implements DeleteHelper {
    private Logger log = LoggerFactory.getLogger(DeleteHelperImpl.class);
    private final HandlerHelper handlerHelper;

    public DeleteHelperImpl(HandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @Override
    public boolean isLockedOut(Request req, Resource r) throws NotAuthorizedException, BadRequestException {
        if (r instanceof DeletableCollectionResource) {
            DeletableCollectionResource dcr = (DeletableCollectionResource)r;
            boolean locked = dcr.isLockedOutRecursive(req);
            if (locked && this.log.isInfoEnabled()) {
                this.log.info("isLocked, as reported by DeletableCollectionResource: " + dcr.getName());
            }
            return locked;
        }
        if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)r;
            ArrayList<? extends Resource> list = new ArrayList<Resource>();
            list.addAll(col.getChildren());
            for (Resource resource : list) {
                if (resource instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)resource;
                    if (!this.isLockedOut(req, rChildDel)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("isLocked: " + resource.getName() + " type:" + resource.getClass());
                    }
                    return true;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("a child resource is not deletable: " + resource.getName() + " type: " + resource.getClass());
                }
                return true;
            }
            return false;
        }
        boolean locked = this.handlerHelper.isLockedOut(req, r);
        if (locked && this.log.isInfoEnabled()) {
            this.log.info("isLocked, as reported by handlerHelper on resource: " + r.getName());
        }
        return locked;
    }

    @Override
    public void delete(DeletableResource r, EventManager eventManager) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (r instanceof DeletableCollectionResource) {
            r.delete();
        } else if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)r);
            ArrayList<? extends Resource> list = new ArrayList<Resource>();
            list.addAll(col.getChildren());
            for (Resource resource : list) {
                if (resource == null) {
                    this.log.warn("got a null item in list");
                    continue;
                }
                if (resource instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)resource;
                    if (eventManager != null) {
                        eventManager.fireEvent(new DeleteEvent(rChildDel));
                    }
                    this.delete(rChildDel, eventManager);
                    continue;
                }
                this.log.warn("Couldnt delete child resource: " + resource.getName() + " of type; " + resource.getClass().getName() + " because it does not implement: " + DeletableResource.class.getCanonicalName());
                throw new ConflictException(resource);
            }
            r.delete();
        } else {
            r.delete();
        }
    }
}

