/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.http11.ContentGenerator;
import com.ettrema.sso.ExternalIdentityProvider;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContentGenerator
implements ContentGenerator {
    private static final Logger log = LoggerFactory.getLogger(SimpleContentGenerator.class);
    private String methodNotAllowed = "<html><body><h1>Method Not Allowed</h1></body></html>";
    private String notFound = "<html><body><h1>${url} Not Found (404)</h1></body></html>";
    private String methodNotImplemented = "<html><body><h1>Method Not Implemented</h1></body></html>";
    private String conflict = "<html><body><h1>Conflict</h1></body></html>";
    private String serverError = "<html><body><h1>Server Error</h1></body></html>";
    private String unauthorised = "<html><body><h1>Not authorised</h1></body></html>";
    private String loginExternal = "<html><body><h1>Not authorised</h1><p>Please login with: ${externalProviders}</p></body></html>";
    private String unknown = "<html><body><h1>Unknown error</h1></body></html>";

    @Override
    public void generate(Resource resource, Request request, Response response, Response.Status status) {
        String template;
        switch (status) {
            case SC_METHOD_NOT_ALLOWED: {
                template = this.getMethodNotAllowed();
                break;
            }
            case SC_NOT_FOUND: {
                template = this.getNotFound();
                break;
            }
            case SC_NOT_IMPLEMENTED: {
                template = this.getMethodNotImplemented();
                break;
            }
            case SC_CONFLICT: {
                template = this.getConflict();
                break;
            }
            case SC_INTERNAL_SERVER_ERROR: {
                template = this.getServerError();
                break;
            }
            case SC_UNAUTHORIZED: {
                template = this.getUnauthorised();
                break;
            }
            default: {
                template = this.getUnknown();
            }
        }
        final String finalTemplate = this.applyTemplates(template, request);
        response.setEntity(new Response.Entity(){

            @Override
            public void write(Response response, OutputStream outputStream) throws Exception {
                PrintWriter pw = new PrintWriter(outputStream, true);
                pw.print(finalTemplate);
                pw.flush();
            }
        });
    }

    private String applyTemplates(String template, Request request) {
        template = template.replace("${url}", request.getAbsolutePath());
        return template;
    }

    @Override
    public void generateLogin(Resource resource, Request request, Response response, AuthenticationService authenticationService) {
        if (authenticationService.canUseExternalAuth(resource, request)) {
            String template = this.loginExternal;
            this.applyTemplates(template, request);
            StringBuilder sb = new StringBuilder();
            sb.append("<ul>");
            for (ExternalIdentityProvider ip : authenticationService.getExternalIdentityProviders()) {
                sb.append("<li>").append("<a href='").append(resource.getName()).append("?_ip=").append(ip.getName()).append("'>").append(ip.getName()).append("</a>").append("</li>");
            }
            sb.append("</ul>");
            final String finalTemplate = this.applyTemplates(template, request);
            response.setEntity(new Response.Entity(){

                @Override
                public void write(Response response, OutputStream outputStream) throws Exception {
                    PrintWriter pw = new PrintWriter(outputStream, true);
                    pw.print(finalTemplate);
                    pw.flush();
                }
            });
        } else {
            this.generate(resource, request, response, Response.Status.SC_UNAUTHORIZED);
        }
    }

    public String getMethodNotAllowed() {
        return this.methodNotAllowed;
    }

    public void setMethodNotAllowed(String methodNotAllowed) {
        this.methodNotAllowed = methodNotAllowed;
    }

    public String getNotFound() {
        return this.notFound;
    }

    public void setNotFound(String notFound) {
        this.notFound = notFound;
    }

    public String getMethodNotImplemented() {
        return this.methodNotImplemented;
    }

    public void setMethodNotImplemented(String methodNotImplemented) {
        this.methodNotImplemented = methodNotImplemented;
    }

    public String getConflict() {
        return this.conflict;
    }

    public void setConflict(String conflict) {
        this.conflict = conflict;
    }

    public String getServerError() {
        return this.serverError;
    }

    public void setServerError(String serverError) {
        this.serverError = serverError;
    }

    public String getUnauthorised() {
        return this.unauthorised;
    }

    public void setUnauthorised(String unauthorised) {
        this.unauthorised = unauthorised;
    }

    public String getUnknown() {
        return this.unknown;
    }

    public void setUnknown(String unknown) {
        this.unknown = unknown;
    }
}

