/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.PropPatchableResource;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.PropPatchHandler;
import com.bradmcevoy.http.webdav.PropPatchRequestParser;
import com.bradmcevoy.http.webdav.PropPatchSetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class PropPatchableSetter
implements PropPatchSetter {
    private final Helper helper;

    PropPatchableSetter(Helper helper) {
        this.helper = helper;
    }

    public PropPatchableSetter() {
        this.helper = new Helper();
    }

    @Override
    public boolean supports(Resource r) {
        return r instanceof PropPatchableResource;
    }

    @Override
    public PropFindResponse setProperties(String href, PropPatchRequestParser.ParseResult parseResult, Resource r) {
        PropPatchableResource ppr = (PropPatchableResource)r;
        PropPatchHandler.Fields fields = this.helper.buildFields(parseResult);
        ppr.setProperties(fields);
        List list = this.helper.buildResult(href, parseResult);
        return (PropFindResponse)list.get(0);
    }

    class Helper {
        Helper() {
        }

        private PropPatchHandler.Fields buildFields(PropPatchRequestParser.ParseResult parseResult) {
            PropPatchHandler.Fields fields = new PropPatchHandler.Fields();
            List<PropPatchHandler.Field> removeFields = fields.removeFields;
            for (QName p : parseResult.getFieldsToRemove()) {
                removeFields.add(new PropPatchHandler.Field(p.getLocalPart()));
            }
            List<PropPatchHandler.SetField> setFields = fields.setFields;
            for (Map.Entry<QName, String> entry : parseResult.getFieldsToSet().entrySet()) {
                setFields.add(new PropPatchHandler.SetField(entry.getKey().getLocalPart(), entry.getValue()));
            }
            return fields;
        }

        private List<PropFindResponse> buildResult(String href, PropPatchRequestParser.ParseResult parseResult) {
            LinkedHashMap<QName, ValueAndType> knownProps = new LinkedHashMap<QName, ValueAndType>();
            for (QName qName : parseResult.getFieldsToRemove()) {
                knownProps.put(qName, null);
            }
            for (Map.Entry entry : parseResult.getFieldsToSet().entrySet()) {
                knownProps.put((QName)entry.getKey(), (ValueAndType)null);
            }
            PropFindResponse resp = new PropFindResponse(href, knownProps, new HashMap<Response.Status, List<PropFindResponse.NameAndError>>());
            ArrayList<PropFindResponse> arrayList = new ArrayList<PropFindResponse>();
            arrayList.add(resp);
            return arrayList;
        }
    }
}

