/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.sso;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.ettrema.sso.SsoSessionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(SsoResourceFactory.class);
    private final ResourceFactory resourceFactory;
    private final SsoSessionProvider ssoSessionProvider;

    public SsoResourceFactory(ResourceFactory resourceFactory, SsoSessionProvider ssoSessionProvider) {
        this.resourceFactory = resourceFactory;
        this.ssoSessionProvider = ssoSessionProvider;
    }

    @Override
    public Resource getResource(String host, String url) throws NotAuthorizedException, BadRequestException {
        Path p = Path.path(url);
        String firstComp = p.getFirst();
        Object oUserTag = null;
        if (firstComp != null) {
            oUserTag = this.ssoSessionProvider.getUserTag(firstComp);
        }
        if (oUserTag == null) {
            log.trace("not a SSO path");
            return this.resourceFactory.getResource(host, url);
        }
        log.trace("is an SSO path");
        Path strippedPath = p.getStripFirst();
        HttpManager.request().getAttributes().put("_sso_user", oUserTag);
        return this.resourceFactory.getResource(host, strippedPath.toString());
    }
}

