/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.APersistentTrie;
import com.github.krukow.clj_lang.EmptyIterator;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentSet;
import com.github.krukow.clj_lang.IPersistentTrie;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineArrayPersistentHATTrie<T>
extends APersistentTrie<T>
implements IObj {
    private static final long serialVersionUID = 6864541653381702688L;
    final IPersistentMap meta;
    final HATTrieNode<T> root;
    final int count;
    private static final int seed = new Random().nextInt();
    private static final int slotPageSize = 64;
    public static final InlineArrayPersistentHATTrie EMPTY = new InlineArrayPersistentHATTrie(null, null, 0);

    public static int getHashCode(String inputString) {
        int result = seed;
        int length = inputString.length();
        for (int i = 0; i < length; ++i) {
            result ^= (result << 5) + inputString.charAt(i) + (result >>> 2);
        }
        return result & Integer.MAX_VALUE & 0x1FF;
    }

    public InlineArrayPersistentHATTrie(HATTrieNode root, IPersistentMap meta, int count) {
        this.root = root;
        this.meta = meta;
        this.count = count;
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    private static final <T> ContainerNode<T> singletonContainer(RandomAccessChars s, int start, int end, T t) {
        char[] strings = new char[64];
        int slen = end - start;
        int k = InlineArrayPersistentHATTrie.encodeNumber(0, slen, strings);
        for (int j = start; j < end; ++j) {
            strings[k++] = s.charAt(j);
        }
        strings[k++] = '\u0000';
        k = InlineArrayPersistentHATTrie.encodeNumber(k, 0, strings);
        return new ContainerNode(strings, new Object[]{t});
    }

    private static final int encodeNumber(int j, int inputlength, char[] tmp) {
        tmp[j++] = (char)(inputlength & 0xFFFF);
        tmp[j++] = (char)(inputlength >> 16 & 0xFFFF);
        return j;
    }

    @Override
    public T getMember(String s) {
        if (this.root == null || s == null) {
            return null;
        }
        return this.root.get(s, 0);
    }

    @Override
    public IPersistentTrie<T> addMember(String s, T t) {
        if (this.root == null) {
            return new InlineArrayPersistentHATTrie<T>(InlineArrayPersistentHATTrie.singletonContainer(new StringRandomAccessChars(s), 0, s.length(), t), null, 1);
        }
        HATTrieNode newRoot = this.root.add(new StringRandomAccessChars(s), 0, s.length(), t);
        if (this.root == newRoot) {
            return this;
        }
        return new InlineArrayPersistentHATTrie<T>(newRoot, this.meta, this.count + 1);
    }

    public IPersistentSet disjoin(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object key) {
        return key instanceof String && this.getMember((String)key) != null;
    }

    public Boolean get(Object key) {
        return this.contains(key);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public IPersistentCollection cons(Object o) {
        if (!(o instanceof Map.Entry)) {
            throw new IllegalArgumentException("Only adding strings is supported");
        }
        Map.Entry e = (Map.Entry)o;
        return (IPersistentCollection)((Object)this.addMember((String)e.getKey(), e.getValue()));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY;
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        return this.root != null ? this.root.nodeIt("") : new EmptyIterator();
    }

    @Override
    public ISeq<String> seq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        return new InlineArrayPersistentHATTrie<T>(this.root, meta, this.count);
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return this.root.toString();
    }

    @Override
    public boolean add(Map.Entry<String, T> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<String, T>> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContainerNode<T>
    implements HATTrieNode<T>,
    ToStringWithPrefix {
        private final char[] contents;
        private final Object[] values;

        public ContainerNode(char[] strings, Object[] values) {
            this.contents = strings;
            this.values = values;
        }

        public String toString() {
            return "NOTIMPLE";
        }

        @Override
        public HATTrieNode add(RandomAccessChars s, int start, int end, T t) {
            int id = this.getIndex(s, start, end);
            if (Util.equals(this.values[id], t)) {
                return this;
            }
            if (this.shouldBurst()) {
                return this.burst(this.contents, start, end, t);
            }
            return this.addString(this.contents, start, end, t);
        }

        @Override
        public T get(String s, int i) {
            int idx = this.getIndex(new StringRandomAccessChars(s), i, s.length());
            if (idx != -1) {
                return (T)this.values[idx];
            }
            return null;
        }

        private HATTrieNode burst(RandomAccessChars s, int start, int end, T t) {
            char f;
            HATTrieNode[] children = new HATTrieNode[256];
            int length = end - start;
            Object empty = s.length() == start ? t : null;
            length = 0;
            int index = -1;
            int slotlength = this.contents.length;
            for (int j = 0; j < slotlength && this.contents[j] != '\u0000'; j += length + 3) {
                length = this.contents[j++] | this.contents[j++] << 16;
                if (empty == null && length == 0) {
                    int n = ++j;
                    int n2 = ++j;
                    ++j;
                    index = this.contents[n] | this.contents[n2] << 16;
                    empty = this.values[index];
                    continue;
                }
                f = this.contents[j++];
                children[f] = ContainerNode.addToNode(children[f], this.contents, j, length, this.values);
            }
            if (empty != t) {
                f = s.charAt(start);
                children[f] = ContainerNode.addToNode(children[f], s, start + 1, end, t);
            }
            return new AccessNode<T>(children, empty);
        }

        private HATTrieNode burst(char[] s, int start, int end, T t) {
            char f;
            HATTrieNode[] children = new HATTrieNode[256];
            Object empty = end == start ? t : null;
            int length = 0;
            int index = -1;
            int slotlength = this.contents.length;
            for (int j = 0; j < slotlength && this.contents[j] != '\u0000'; j += length + 3) {
                length = this.contents[j++] | this.contents[j++] << 16;
                if (empty == null && length == 0) {
                    int n = ++j;
                    int n2 = ++j;
                    ++j;
                    index = this.contents[n] | this.contents[n2] << 16;
                    empty = this.values[index];
                    continue;
                }
                f = this.contents[j++];
                children[f] = ContainerNode.addToNode(children[f], this.contents, j, length, this.values);
            }
            if (empty != t) {
                f = s[start];
                children[f] = ContainerNode.addToNode(children[f], s, start + 1, end - start - 1, this.values);
            }
            return new AccessNode<T>(children, empty);
        }

        private static final <T> HATTrieNode addToNode(HATTrieNode hatTrieNode, char[] contents, int j, int length, Object[] values) {
            int idIndex = j + length + 1;
            int id = contents[idIndex++] | contents[idIndex++] << 16;
            if (hatTrieNode == null) {
                char[] newcontents = new char[64];
                int nextindex = InlineArrayPersistentHATTrie.encodeNumber(0, length, newcontents);
                System.arraycopy(contents, j, newcontents, nextindex++, length);
                newcontents[nextindex++] = '\u0000';
                return new ContainerNode<T>(newcontents, new Object[]{values[id]});
            }
            return hatTrieNode.add(new CharArrayRandomAccessChars(contents), j, j + length, values[id]);
        }

        private static final <T> HATTrieNode addToNode(HATTrieNode hatTrieNode, RandomAccessChars s, int start, int end, T t) {
            if (hatTrieNode == null) {
                return InlineArrayPersistentHATTrie.singletonContainer(s, start, end, t);
            }
            return hatTrieNode.add(s, start, end, t);
        }

        private ContainerNode<T> addString(String inputString, int index, T t) {
            int j;
            int k = 0;
            int length = 0;
            int slotlength = this.contents.length;
            int inputlength = inputString.length() - index;
            boolean match = false;
            for (j = 0; j < slotlength && this.contents[j] != '\u0000'; j += length + 3) {
                match = true;
                if (inputlength != (length = this.contents[j++] | this.contents[j++] << 16)) {
                    match = false;
                } else {
                    int strIdx = index;
                    k = j;
                    while (this.contents[k] != '\u0000') {
                        if (this.contents[k] != inputString.charAt(strIdx++)) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                    ++k;
                }
                if (!match) continue;
                return this;
            }
            char[] tmp = this.contents;
            int newslotlength = slotlength;
            while (newslotlength - inputlength < j + 5) {
                tmp = new char[newslotlength + 64];
                System.arraycopy(this.contents, 0, tmp, 0, newslotlength);
                newslotlength = tmp.length;
            }
            j = InlineArrayPersistentHATTrie.encodeNumber(j, inputlength, tmp);
            System.arraycopy(inputString, 0, tmp, j, inputlength);
            j += inputlength;
            tmp[j++] = '\u0000';
            InlineArrayPersistentHATTrie.encodeNumber(j, this.values.length, tmp);
            Object[] newValues = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            newValues[this.values.length] = t;
            return new ContainerNode<T>(tmp, this.values);
        }

        private ContainerNode<T> addString(char[] inputString, int start, int end, T t) {
            int j;
            int k = 0;
            int length = 0;
            int slotlength = this.contents.length;
            int inputlength = end - start;
            boolean match = false;
            for (j = 0; j < slotlength && this.contents[j] != '\u0000'; j += length + 3) {
                match = true;
                if (inputlength != (length = this.contents[j++] | this.contents[j++] << 16)) {
                    match = false;
                } else {
                    int strIdx = start;
                    k = j;
                    while (this.contents[k] != '\u0000') {
                        if (this.contents[k] != inputString[strIdx++]) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                    ++k;
                }
                if (!match) continue;
                return this;
            }
            char[] tmp = this.contents;
            int newslotlength = slotlength;
            while (newslotlength - inputlength < j + 5) {
                tmp = new char[newslotlength + 64];
                System.arraycopy(this.contents, 0, tmp, 0, newslotlength);
                newslotlength = tmp.length;
            }
            j = InlineArrayPersistentHATTrie.encodeNumber(j, inputlength, tmp);
            System.arraycopy(inputString, 0, tmp, j, inputlength);
            j += inputlength;
            tmp[j++] = '\u0000';
            InlineArrayPersistentHATTrie.encodeNumber(j, this.values.length, tmp);
            Object[] newValues = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            newValues[this.values.length] = t;
            return new ContainerNode<T>(tmp, this.values);
        }

        public int getIndex(RandomAccessChars input, int start, int end) {
            int k = 0;
            int length = 0;
            int inputlength = end - start;
            int slotlength = this.contents.length;
            boolean match = false;
            for (int j = 0; j < slotlength && this.contents[j] != '\u0000'; j += length + 3) {
                match = true;
                if (inputlength != (length = this.contents[j++] | this.contents[j++] << 16)) {
                    match = false;
                } else {
                    int strIdx = start;
                    k = j;
                    while (this.contents[k] != '\u0000') {
                        if (this.contents[k] != input.charAt(strIdx++)) {
                            match = false;
                            break;
                        }
                        ++k;
                    }
                    ++k;
                }
                if (!match) continue;
                return this.contents[k++] | this.contents[k] << 16;
            }
            return -1;
        }

        private boolean shouldBurst() {
            return this.values.length == 4;
        }

        @Override
        public Iterator<Map.Entry<String, T>> nodeIt(String prefix) {
            return new Iterator<Map.Entry<String, T>>(){
                int j = 0;

                @Override
                public boolean hasNext() {
                    return ContainerNode.this.contents[this.j] == '\u0000';
                }

                @Override
                public Map.Entry<String, T> next() {
                    int length = ContainerNode.this.contents[this.j++] | ContainerNode.this.contents[this.j++] << 16;
                    char[] str = new char[length];
                    int i = 0;
                    while (i < length) {
                        str[i++] = ContainerNode.this.contents[this.j++];
                    }
                    ++this.j;
                    String key = new String(str);
                    int idx = ContainerNode.this.contents[this.j++] | ContainerNode.this.contents[this.j++] << 16;
                    return new MapEntry<String, Object>(key, ContainerNode.this.values[idx]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String toStringWithPrefix(String prefix) {
            return prefix + this.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AccessNode<T>
    implements HATTrieNode<T>,
    ToStringWithPrefix {
        private final HATTrieNode<T>[] children;
        private final T emptyPtr;

        public AccessNode(HATTrieNode[] children, T emptyPtr) {
            this.children = children;
            this.emptyPtr = emptyPtr;
        }

        public String toString() {
            return this.toStringWithPrefix("");
        }

        @Override
        public String toStringWithPrefix(String prefix) {
            StringBuilder sb = new StringBuilder();
            String nestedPrefix = prefix + "  ";
            sb.append(prefix);
            sb.append("(access-node\n").append(nestedPrefix);
            for (int i = 0; i < this.children.length; ++i) {
                HATTrieNode<T> node = this.children[i];
                if (node == null) continue;
                sb.append((char)i).append(" -> ").append(((ToStringWithPrefix)((Object)node)).toStringWithPrefix(nestedPrefix)).append(";\n").append(nestedPrefix);
            }
            if (this.emptyPtr != null) {
                sb.append("\n").append(prefix).append("**");
            }
            sb.append(prefix).append(")");
            return sb.toString();
        }

        @Override
        public HATTrieNode<T> add(RandomAccessChars s, int start, int end, T t) {
            int length = s.length();
            if (start < length) {
                char ichar = s.charAt(start);
                HATTrieNode<T> hatTrieNode = this.children[ichar];
                if (hatTrieNode != null) {
                    HATTrieNode newNode = hatTrieNode.add(s, start + 1, end, t);
                    if (newNode == hatTrieNode) {
                        return this;
                    }
                    HATTrieNode[] newArr = new HATTrieNode[this.children.length];
                    System.arraycopy(this.children, 0, newArr, 0, this.children.length);
                    newArr[ichar] = newNode;
                    return new AccessNode<T>(newArr, this.emptyPtr);
                }
                ContainerNode c = InlineArrayPersistentHATTrie.singletonContainer(s, start + 1, end, t);
                HATTrieNode[] newArr = new HATTrieNode[this.children.length];
                System.arraycopy(this.children, 0, newArr, 0, this.children.length);
                newArr[ichar] = c;
                return new AccessNode<T>(newArr, this.emptyPtr);
            }
            if (start == length && this.emptyPtr == null) {
                return new AccessNode<T>(this.children, t);
            }
            return this;
        }

        @Override
        public T get(String s, int i) {
            if (i == s.length()) {
                return this.emptyPtr;
            }
            HATTrieNode<T> c = this.children[s.charAt(i)];
            if (c == null) {
                return null;
            }
            return c.get(s, i + 1);
        }

        @Override
        public Iterator<Map.Entry<String, T>> nodeIt(String prefix) {
            return new AccessNodeIterator(this, prefix);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class AccessNodeIterator<T>
        implements Iterator<MapEntry<String, T>> {
            private final HATTrieNode[] children;
            private final T emptyPtr;
            private int index = -1;
            private final String prefix;
            Iterator<MapEntry<String, T>> current = null;

            AccessNodeIterator(AccessNode<T> node, String prefix) {
                this.children = ((AccessNode)node).children;
                this.emptyPtr = ((AccessNode)node).emptyPtr;
                this.prefix = prefix;
                this.moveCurIfNeeded();
            }

            private void moveCurIfNeeded() {
                if (this.index == -1) {
                    if (this.emptyPtr == null) {
                        this.index = 0;
                    } else {
                        return;
                    }
                }
                if (this.current != null && this.current.hasNext()) {
                    return;
                }
                while (this.index < this.children.length && this.children[this.index] == null) {
                    ++this.index;
                }
                if (this.index == this.children.length) {
                    this.current = null;
                } else {
                    String prefix = this.prefix + (char)this.index;
                    this.current = this.children[this.index++].nodeIt(prefix);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.index == -1 && this.emptyPtr != null) {
                    return true;
                }
                while (this.current != null && !this.current.hasNext()) {
                    this.moveCurIfNeeded();
                }
                return this.current != null && this.current.hasNext();
            }

            @Override
            public MapEntry<String, T> next() {
                if (this.index == -1 && this.emptyPtr != null) {
                    this.index = 0;
                    this.moveCurIfNeeded();
                    return new MapEntry<String, T>(this.prefix, this.emptyPtr);
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class CharArrayRandomAccessChars
    implements RandomAccessChars {
        private final char[] s;

        public CharArrayRandomAccessChars(char[] s) {
            this.s = s;
        }

        public char charAt(int index) {
            return this.s[index];
        }

        public int length() {
            return this.s.length;
        }
    }

    private static class StringRandomAccessChars
    implements RandomAccessChars {
        private final String s;

        public StringRandomAccessChars(String s) {
            this.s = s;
        }

        public char charAt(int index) {
            return this.s.charAt(index);
        }

        public int length() {
            return this.s.length();
        }
    }

    private static interface RandomAccessChars {
        public char charAt(int var1);

        public int length();
    }

    private static interface ToStringWithPrefix {
        public String toStringWithPrefix(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface HATTrieNode<T> {
        public T get(String var1, int var2);

        public Iterator<Map.Entry<String, T>> nodeIt(String var1);

        public HATTrieNode add(RandomAccessChars var1, int var2, int var3, T var4);
    }
}

