/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.exist.dom.QName;
import org.exist.indexing.range.ComplexTextCollector;
import org.exist.indexing.range.RangeIndexConfigAttributeCondition;
import org.exist.indexing.range.RangeIndexConfigCondition;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexConfigField;
import org.exist.indexing.range.TextCollector;
import org.exist.indexing.range.conversion.TypeConverter;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.Predicate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexRangeIndexConfigElement
extends RangeIndexConfigElement {
    public static final Comparator<ComplexRangeIndexConfigElement> NUM_CONDITIONS_COMPARATOR = Comparator.comparingInt(ComplexRangeIndexConfigElement::getNumberOfConditions).reversed();
    public static final String FIELD_ELEMENT = "field";
    public static final String CONDITION_ELEMENT = "condition";
    private static final Logger LOG = LogManager.getLogger(ComplexRangeIndexConfigElement.class);
    private Map<String, RangeIndexConfigField> fields = new HashMap<String, RangeIndexConfigField>();
    protected ArrayList<RangeIndexConfigCondition> conditions = new ArrayList();

    public ArrayList<RangeIndexConfigCondition> getConditions() {
        return this.conditions;
    }

    public int getNumberOfConditions() {
        return this.conditions.size();
    }

    public ComplexRangeIndexConfigElement(Element node, NodeList children, Map<String, String> namespaces) throws DatabaseConfigurationException {
        super(node, namespaces);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (FIELD_ELEMENT.equals(child.getLocalName())) {
                RangeIndexConfigField field = new RangeIndexConfigField(this.path, (Element)child, namespaces);
                this.fields.put(field.getName(), field);
                continue;
            }
            if (CONDITION_ELEMENT.equals(child.getLocalName())) {
                this.conditions.add(new RangeIndexConfigAttributeCondition((Element)child, this.path));
                continue;
            }
            if ("filter".equals(child.getLocalName())) {
                this.analyzer.addFilter((Element)child);
                continue;
            }
            LOG.warn("Invalid element encountered for range index configuration: " + child.getLocalName());
        }
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isCaseSensitive(String fieldName) {
        for (RangeIndexConfigField field : this.fields.values()) {
            if (fieldName == null || !fieldName.equals(field.getName())) continue;
            return field.isCaseSensitive();
        }
        return this.caseSensitive;
    }

    @Override
    public boolean match(NodePath other) {
        if (this.isQNameIndex) {
            QName qn1 = this.path.getLastComponent();
            QName qn2 = other.getLastComponent();
            return qn1.getNameType() == qn2.getNameType() && qn2.equals((Object)qn1);
        }
        return this.path.match(other);
    }

    @Override
    public boolean find(NodePath other) {
        return this.getField(other) != null;
    }

    @Override
    public TextCollector getCollector(NodePath path) {
        return new ComplexTextCollector(this, path);
    }

    @Override
    public Analyzer getAnalyzer(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return this.analyzer;
        }
        return null;
    }

    public RangeIndexConfigField getField(NodePath path) {
        for (RangeIndexConfigField field : this.fields.values()) {
            if (!field.match(path)) continue;
            return field;
        }
        return null;
    }

    public RangeIndexConfigField getField(NodePath parentPath, NodePath path) {
        for (RangeIndexConfigField field : this.fields.values()) {
            if (!field.match(parentPath, path)) continue;
            return field;
        }
        return null;
    }

    @Override
    public int getType(String fieldName) {
        RangeIndexConfigField field = this.fields.get(fieldName);
        if (field != null) {
            return field.getType();
        }
        return 11;
    }

    @Override
    public TypeConverter getTypeConverter(String fieldName) {
        RangeIndexConfigField field = this.fields.get(fieldName);
        if (field != null) {
            return field.getTypeConverter();
        }
        return null;
    }

    public boolean matchConditions(Node node) {
        for (RangeIndexConfigCondition condition : this.conditions) {
            if (condition.matches(node)) continue;
            return false;
        }
        return true;
    }

    public boolean findCondition(Predicate predicate) {
        for (RangeIndexConfigCondition condition : this.conditions) {
            if (!condition.find(predicate)) continue;
            return true;
        }
        return false;
    }
}

