/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.lucene.LuceneUtil;
import org.exist.numbering.NodeId;

public class NodesFilter
extends Filter {
    private final NodeSet contextSet;
    private Map<Integer, DocIdSet> cachedSets = new HashMap<Integer, DocIdSet>();

    public NodesFilter(NodeSet contextSet) {
        this.contextSet = contextSet;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet cached = this.cachedSets.get(context.ord);
        return cached;
    }

    public void init(IndexReader reader) throws IOException {
        for (AtomicReaderContext context : reader.leaves()) {
            this.init(context);
        }
    }

    private void init(AtomicReaderContext context) throws IOException {
        AtomicReader reader = context.reader();
        FixedBitSet result = new FixedBitSet(reader.maxDoc());
        this.cachedSets.put(context.ord, (DocIdSet)result);
        Fields fields = reader.fields();
        Terms terms = fields.terms("id");
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator(null);
            DocsEnum docs = null;
            block0: for (NodeProxy node : this.contextSet) {
                BytesRef nextId;
                BytesRef lowerBound = new BytesRef(LuceneUtil.createId((int)node.getDoc().getDocId(), (NodeId)node.getNodeId()));
                BytesRef upperBound = new BytesRef(LuceneUtil.createId((int)node.getDoc().getDocId(), (NodeId)node.getNodeId().nextSibling()));
                if (termsEnum.seekCeil(lowerBound) == TermsEnum.SeekStatus.END) continue;
                while ((nextId = termsEnum.term()).compareTo(upperBound) < 0) {
                    docs = termsEnum.docs(null, docs, 0);
                    while (docs.nextDoc() != Integer.MAX_VALUE) {
                        int id = docs.docID();
                        result.set(id);
                    }
                    if (termsEnum.next() != null) continue;
                    continue block0;
                }
            }
        }
    }

    private static boolean startsWith(byte[] key, int offset, int length, byte[] prefix) {
        if (length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (key[offset + i] == prefix[i]) continue;
            return false;
        }
        return true;
    }
}

