/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.lucene.LuceneIndex;
import org.exist.indexing.range.RangeIndexWorker;
import org.exist.storage.DBBroker;

public class RangeIndex
extends LuceneIndex {
    protected static final Logger LOG = LogManager.getLogger(RangeIndex.class);
    public static final String ID = RangeIndex.class.getName();
    private static final String DIR_NAME = "range";
    private Analyzer defaultAnalyzer = new KeywordAnalyzer();

    public String getDirName() {
        return DIR_NAME;
    }

    public IndexWorker getWorker(DBBroker broker) {
        return new RangeIndexWorker(this, broker);
    }

    public String getIndexId() {
        return ID;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public static enum Operator {
        GT("gt", true),
        LT("lt", true),
        EQ("eq", true),
        GE("ge", true),
        LE("le", true),
        NE("ne", true),
        ENDS_WITH("ends-with", false),
        STARTS_WITH("starts-with", false),
        CONTAINS("contains", false),
        MATCH("matches", false);

        private final String name;
        private final boolean supportsCollation;
        private static final Map<String, Operator> LOOKUP_MAP;

        private Operator(String name, boolean supportsCollation) {
            this.name = name;
            this.supportsCollation = supportsCollation;
        }

        public String toString() {
            return this.name;
        }

        public boolean supportsCollation() {
            return this.supportsCollation;
        }

        public static Operator getByName(String name) {
            return LOOKUP_MAP.get(name);
        }

        static {
            LOOKUP_MAP = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                LOOKUP_MAP.put(operator.name, operator);
            }
        }
    }
}

