/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import com.ibm.icu.text.Collator;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.collation.ICUCollationAttributeFactory;
import org.apache.lucene.util.AttributeFactory;
import org.exist.util.Collations;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.w3c.dom.Element;

public class RangeIndexAnalyzer
extends Analyzer {
    private static final Logger LOG = LogManager.getLogger(RangeIndexAnalyzer.class);
    private List<FilterConfig> filterConfigs = new ArrayList<FilterConfig>();
    private Collator collator = null;

    public void addFilter(Element filter) throws DatabaseConfigurationException {
        this.filterConfigs.add(new FilterConfig(filter));
    }

    public void addCollation(String uri) throws DatabaseConfigurationException {
        try {
            this.collator = Collations.getCollationFromURI((String)uri);
        }
        catch (XPathException e) {
            throw new DatabaseConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        KeywordTokenizer src;
        AttributeFactory factory = AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY;
        if (this.collator != null) {
            factory = new ICUCollationAttributeFactory(this.collator);
        }
        KeywordTokenizer tok = src = new KeywordTokenizer(factory, reader, 256);
        for (FilterConfig filter : this.filterConfigs) {
            try {
                tok = (TokenStream)filter.constructor.newInstance(tok);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }

    private static class FilterConfig {
        Constructor<?> constructor;

        FilterConfig(Element config) throws DatabaseConfigurationException {
            String className = config.getAttribute("class");
            if (className == null) {
                throw new DatabaseConfigurationException("No class specified for filter");
            }
            try {
                Class<?> clazz = Class.forName(className);
                if (!TokenFilter.class.isAssignableFrom(clazz)) {
                    throw new DatabaseConfigurationException("Filter " + className + " is not a subclass of " + TokenFilter.class.getName());
                }
                this.constructor = clazz.getConstructor(TokenStream.class);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseConfigurationException("Filter not found: " + className, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new DatabaseConfigurationException("Filter class " + className + " has non-default constructor", (Throwable)e);
            }
        }
    }
}

