/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.io.IOException;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.exist.dom.QName;
import org.exist.indexing.lucene.LuceneIndexConfig;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexAnalyzer;
import org.exist.indexing.range.SimpleTextCollector;
import org.exist.indexing.range.TextCollector;
import org.exist.indexing.range.conversion.TypeConverter;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RangeIndexConfigElement {
    protected static final String FILTER_ELEMENT = "filter";
    protected NodePath path;
    private int type;
    private RangeIndexConfigElement nextConfig;
    protected boolean isQNameIndex;
    protected RangeIndexAnalyzer analyzer;
    protected boolean includeNested;
    protected boolean caseSensitive;
    protected boolean usesCollation;
    protected int wsTreatment;
    private TypeConverter typeConverter;

    public RangeIndexConfigElement(Element node, Map<String, String> namespaces) throws DatabaseConfigurationException {
        String custom;
        String caseStr;
        String nested;
        String typeStr;
        String match;
        block19: {
            this.path = null;
            this.type = 22;
            this.nextConfig = null;
            this.isQNameIndex = false;
            this.analyzer = new RangeIndexAnalyzer();
            this.includeNested = false;
            this.caseSensitive = true;
            this.usesCollation = false;
            this.wsTreatment = 0;
            this.typeConverter = null;
            match = node.getAttribute("match");
            if (match != null && match.length() > 0) {
                try {
                    this.path = new NodePath(namespaces, match);
                    if (this.path.length() == 0) {
                        throw new DatabaseConfigurationException("Range index module: Invalid match path in collection config: " + match);
                    }
                    break block19;
                }
                catch (IllegalArgumentException e) {
                    throw new DatabaseConfigurationException("Range index module: invalid qname in configuration: " + e.getMessage());
                }
            }
            if (node.hasAttribute("qname")) {
                QName qname = LuceneIndexConfig.parseQName((Element)node, namespaces);
                this.path = new NodePath(NodePath.SKIP);
                this.path.addComponent(qname);
                this.isQNameIndex = true;
            }
        }
        if ((typeStr = node.getAttribute("type")) != null && typeStr.length() > 0) {
            try {
                this.type = Type.getType((String)typeStr);
            }
            catch (XPathException e) {
                throw new DatabaseConfigurationException("Invalid type declared for range index on " + match + ": " + typeStr);
            }
        }
        this.parseChildren(node);
        String collation = node.getAttribute("collation");
        if (collation != null && collation.length() > 0) {
            this.analyzer.addCollation(collation);
            this.usesCollation = true;
        }
        this.includeNested = (nested = node.getAttribute("nested")) == null || nested.length() == 0 || nested.equalsIgnoreCase("yes");
        String whitespace = node.getAttribute("whitespace");
        if (whitespace != null) {
            if ("trim".equalsIgnoreCase(whitespace)) {
                this.wsTreatment = 3;
            } else if ("normalize".equalsIgnoreCase(whitespace)) {
                this.wsTreatment = 7;
            }
        }
        if ((caseStr = node.getAttribute("case")) != null && caseStr.length() > 0) {
            this.caseSensitive = caseStr.equalsIgnoreCase("yes");
        }
        if ((custom = node.getAttribute("converter")) != null && custom.length() > 0) {
            try {
                Class<?> customClass = Class.forName(custom);
                this.typeConverter = (TypeConverter)customClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                RangeIndex.LOG.warn("Class for custom-type not found: " + custom);
            }
            catch (InstantiationException e) {
                RangeIndex.LOG.warn("Failed to initialize custom-type: " + custom, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                RangeIndex.LOG.warn("Failed to initialize custom-type: " + custom, (Throwable)e);
            }
        }
    }

    private void parseChildren(Node root) throws DatabaseConfigurationException {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !FILTER_ELEMENT.equals(child.getLocalName())) continue;
            this.analyzer.addFilter((Element)child);
        }
    }

    public Field convertToField(String fieldName, String content) throws IOException {
        TypeConverter custom = this.getTypeConverter(fieldName);
        if (custom != null) {
            return custom.toField(fieldName, content);
        }
        int fieldType = this.getType(fieldName);
        try {
            switch (fieldType) {
                case 31: 
                case 37: 
                case 42: {
                    long lvalue = Long.parseLong(content);
                    return new LongField(fieldName, lvalue, LongField.TYPE_NOT_STORED);
                }
                case 38: 
                case 39: 
                case 43: 
                case 44: {
                    int ivalue = Integer.parseInt(content);
                    return new IntField(fieldName, ivalue, IntField.TYPE_NOT_STORED);
                }
                case 32: 
                case 34: {
                    double dvalue = Double.parseDouble(content);
                    return new DoubleField(fieldName, dvalue, DoubleField.TYPE_NOT_STORED);
                }
                case 33: {
                    float fvalue = Float.parseFloat(content);
                    return new FloatField(fieldName, fvalue, FloatField.TYPE_NOT_STORED);
                }
                case 51: {
                    DateValue dv = new DateValue(content);
                    long dl = RangeIndexConfigElement.dateToLong(dv);
                    return new LongField(fieldName, dl, LongField.TYPE_NOT_STORED);
                }
                case 52: {
                    TimeValue tv = new TimeValue(content);
                    long tl = RangeIndexConfigElement.timeToLong(tv);
                    return new LongField(fieldName, tl, LongField.TYPE_NOT_STORED);
                }
                case 50: {
                    DateTimeValue dtv = new DateTimeValue(content);
                    String dateStr = RangeIndexConfigElement.dateTimeToString(dtv);
                    return new TextField(fieldName, dateStr, Field.Store.NO);
                }
            }
            return new TextField(fieldName, content, Field.Store.NO);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return null;
    }

    public static BytesRef convertToBytes(AtomicValue content) throws XPathException {
        BytesRefBuilder bytes = new BytesRefBuilder();
        switch (content.getType()) {
            case 31: 
            case 37: 
            case 42: {
                NumericUtils.longToPrefixCoded((long)((IntegerValue)content).getLong(), (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                NumericUtils.intToPrefixCoded((int)((IntegerValue)content).getInt(), (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 32: {
                long dv = NumericUtils.doubleToSortableLong((double)((DecimalValue)content).getDouble());
                NumericUtils.longToPrefixCoded((long)dv, (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 34: {
                long lv = NumericUtils.doubleToSortableLong((double)((DoubleValue)content).getDouble());
                NumericUtils.longToPrefixCoded((long)lv, (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 33: {
                int iv = NumericUtils.floatToSortableInt((float)((FloatValue)content).getValue());
                NumericUtils.longToPrefixCoded((long)iv, (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 51: {
                long dl = RangeIndexConfigElement.dateToLong((DateValue)content);
                NumericUtils.longToPrefixCoded((long)dl, (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 52: {
                long tl = RangeIndexConfigElement.timeToLong((TimeValue)content);
                NumericUtils.longToPrefixCoded((long)tl, (int)0, (BytesRefBuilder)bytes);
                break;
            }
            case 50: {
                String dt = RangeIndexConfigElement.dateTimeToString((DateTimeValue)content);
                bytes.copyChars((CharSequence)dt);
                break;
            }
            default: {
                bytes.copyChars((CharSequence)content.getStringValue());
            }
        }
        return bytes.toBytesRef();
    }

    public static long dateToLong(DateValue date) {
        XMLGregorianCalendar utccal = date.calendar.normalize();
        return ((long)utccal.getYear() << 16) + ((long)utccal.getMonth() << 8) + (long)utccal.getDay();
    }

    public static long timeToLong(TimeValue time) {
        return time.getTimeInMillis();
    }

    public static String dateTimeToString(DateTimeValue dtv) {
        XMLGregorianCalendar utccal = dtv.calendar.normalize();
        StringBuilder sb = new StringBuilder();
        RangeIndexConfigElement.formatNumber(utccal.getMillisecond(), 3, sb);
        RangeIndexConfigElement.formatNumber(utccal.getSecond(), 2, sb);
        RangeIndexConfigElement.formatNumber(utccal.getMinute(), 2, sb);
        RangeIndexConfigElement.formatNumber(utccal.getHour(), 2, sb);
        RangeIndexConfigElement.formatNumber(utccal.getDay(), 2, sb);
        RangeIndexConfigElement.formatNumber(utccal.getMonth(), 2, sb);
        RangeIndexConfigElement.formatNumber(utccal.getYear(), 4, sb);
        return sb.toString();
    }

    public static void formatNumber(int number, int digits, StringBuilder sb) {
        int count = 0;
        for (long n = (long)number; n > 0L; n /= 10L) {
            int digit = 48 + (int)n % 10;
            sb.insert(0, (char)digit);
            if (++count == digits) break;
        }
        if (count < digits) {
            for (int i = count; i < digits; ++i) {
                sb.insert(0, '0');
            }
        }
    }

    public TextCollector getCollector(NodePath path) {
        return new SimpleTextCollector(this, this.includeNested, this.wsTreatment, this.caseSensitive);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getAnalyzer(String field) {
        return this.analyzer;
    }

    public boolean isCaseSensitive(String fieldName) {
        return this.caseSensitive;
    }

    public boolean usesCollation() {
        return this.usesCollation;
    }

    public boolean isComplex() {
        return false;
    }

    public int getType(String fieldName) {
        return this.type;
    }

    public int getType() {
        return this.type;
    }

    public TypeConverter getTypeConverter(String fieldName) {
        return this.typeConverter;
    }

    public NodePath getNodePath() {
        return this.path;
    }

    public void add(RangeIndexConfigElement config) {
        if (this.nextConfig == null) {
            this.nextConfig = config;
        } else {
            this.nextConfig.add(config);
        }
    }

    public RangeIndexConfigElement getNext() {
        return this.nextConfig;
    }

    public boolean match(NodePath other) {
        if (this.isQNameIndex) {
            QName qn1 = this.path.getLastComponent();
            QName qn2 = other.getLastComponent();
            return qn1.getNameType() == qn2.getNameType() && qn2.equals((Object)qn1);
        }
        return other.match(this.path);
    }

    public boolean find(NodePath other) {
        return this.match(other);
    }
}

