/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.Map;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.conversion.TypeConverter;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;

public class RangeIndexConfigField {
    private String name;
    private NodePath path = null;
    private NodePath relPath = null;
    private int type = 22;
    private TypeConverter typeConverter = null;
    protected boolean includeNested = false;
    protected int wsTreatment = 0;
    protected boolean caseSensitive = true;

    public RangeIndexConfigField(NodePath parentPath, Element elem, Map<String, String> namespaces) throws DatabaseConfigurationException {
        String caseStr;
        String nested;
        String custom;
        this.name = elem.getAttribute("name");
        this.path = parentPath;
        if (this.name == null || this.name.length() == 0) {
            throw new DatabaseConfigurationException("Range index module: field element requires a name attribute");
        }
        String match = elem.getAttribute("match");
        if (match != null && match.length() > 0) {
            try {
                this.relPath = new NodePath(namespaces, match);
                if (this.relPath.length() == 0) {
                    throw new DatabaseConfigurationException("Range index module: Invalid match path in collection config: " + match);
                }
                this.path = new NodePath(parentPath);
                this.path.append(this.relPath);
            }
            catch (IllegalArgumentException e) {
                throw new DatabaseConfigurationException("Range index module: invalid qname in configuration: " + e.getMessage());
            }
        } else {
            this.path = parentPath;
        }
        String typeStr = elem.getAttribute("type");
        if (typeStr != null && typeStr.length() > 0) {
            try {
                this.type = Type.getType((String)typeStr);
            }
            catch (XPathException e) {
                throw new DatabaseConfigurationException("Invalid type declared for range index on " + match + ": " + typeStr);
            }
        }
        if ((custom = elem.getAttribute("converter")) != null && custom.length() > 0) {
            try {
                Class<?> customClass = Class.forName(custom);
                this.typeConverter = (TypeConverter)customClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                RangeIndex.LOG.warn("Class for custom-type not found: " + custom);
            }
            catch (InstantiationException e) {
                RangeIndex.LOG.warn("Failed to initialize custom-type: " + custom, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                RangeIndex.LOG.warn("Failed to initialize custom-type: " + custom, (Throwable)e);
            }
        }
        this.includeNested = (nested = elem.getAttribute("nested")) == null || nested.equalsIgnoreCase("yes");
        this.path.setIncludeDescendants(this.includeNested);
        String whitespace = elem.getAttribute("whitespace");
        if (whitespace != null) {
            if ("trim".equalsIgnoreCase(whitespace)) {
                this.wsTreatment = 3;
            } else if ("normalize".equalsIgnoreCase(whitespace)) {
                this.wsTreatment = 7;
            }
        }
        if ((caseStr = elem.getAttribute("case")) != null && caseStr.length() > 0) {
            this.caseSensitive = caseStr.equalsIgnoreCase("yes");
        }
    }

    public String getName() {
        return this.name;
    }

    public NodePath getPath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public boolean match(NodePath other) {
        return this.path.match(other);
    }

    public boolean match(NodePath parentPath, NodePath other) {
        if (this.relPath == null) {
            return parentPath.match(other);
        }
        NodePath absPath = new NodePath(parentPath);
        absPath.append(this.relPath);
        return absPath.match(other);
    }

    public int whitespaceTreatment() {
        return this.wsTreatment;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean includeNested() {
        return this.includeNested;
    }
}

