/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntDocValuesField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.SymbolTable;
import org.exist.indexing.AbstractStreamListener;
import org.exist.indexing.IndexController;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.indexing.QNamedKeysIndex;
import org.exist.indexing.StreamListener;
import org.exist.indexing.lucene.BinaryTokenStream;
import org.exist.indexing.lucene.LuceneIndexWorker;
import org.exist.indexing.lucene.LuceneUtil;
import org.exist.indexing.range.ComplexTextCollector;
import org.exist.indexing.range.NodesFilter;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexConfig;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexDoc;
import org.exist.indexing.range.SimpleTextCollector;
import org.exist.indexing.range.TextCollector;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.btree.DBException;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.range.RangeQueryRewriter;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RangeIndexWorker
implements OrderedValuesIndex,
QNamedKeysIndex {
    private static final Logger LOG = LogManager.getLogger(RangeIndexWorker.class);
    public static final String FIELD_NODE_ID = "nodeId";
    public static final String FIELD_DOC_ID = "docId";
    public static final String FIELD_ADDRESS = "address";
    public static final String FIELD_ID = "id";
    private static Set<String> LOAD_FIELDS = new TreeSet<String>();
    private final RangeIndex index;
    private final DBBroker broker;
    private IndexController controller;
    private DocumentImpl currentDoc;
    private StreamListener.ReindexMode mode = StreamListener.ReindexMode.STORE;
    private List<RangeIndexDoc> nodesToWrite;
    private Set<NodeId> nodesToRemove = null;
    private RangeIndexConfig config = null;
    private RangeIndexListener listener = new RangeIndexListener();
    private Stack<TextCollector> contentStack = null;
    private int cachedNodesSize = 0;
    private int maxCachedNodesSize = 0x400000;

    public RangeIndexWorker(RangeIndex index, DBBroker broker) {
        this.index = index;
        this.broker = broker;
    }

    public Query toQuery(String field, QName qname, AtomicValue content, RangeIndex.Operator operator, DocumentSet docs) throws XPathException {
        int type = content.getType();
        BytesRef key = null;
        if (Type.subTypeOf((int)type, (int)22)) {
            if (operator != RangeIndex.Operator.MATCH) {
                key = this.analyzeContent(field, qname, content.getStringValue(), docs);
            }
            switch (operator) {
                case EQ: {
                    return new TermQuery(new Term(field, key));
                }
                case NE: {
                    BooleanQuery qnot = new BooleanQuery();
                    WildcardQuery query = new WildcardQuery(new Term(field, new BytesRef((CharSequence)"*")));
                    query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
                    qnot.add((Query)query, BooleanClause.Occur.MUST);
                    qnot.add((Query)new TermQuery(new Term(field, key)), BooleanClause.Occur.MUST_NOT);
                    return qnot;
                }
                case STARTS_WITH: {
                    return new PrefixQuery(new Term(field, key));
                }
                case ENDS_WITH: {
                    BytesRefBuilder bytes = new BytesRefBuilder();
                    bytes.append((byte)42);
                    bytes.append(key);
                    WildcardQuery query = new WildcardQuery(new Term(field, bytes.toBytesRef()));
                    query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
                    return query;
                }
                case CONTAINS: {
                    BytesRefBuilder bytes = new BytesRefBuilder();
                    bytes.append((byte)42);
                    bytes.append(key);
                    bytes.append((byte)42);
                    WildcardQuery query = new WildcardQuery(new Term(field, bytes.toBytesRef()));
                    query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
                    return query;
                }
                case MATCH: {
                    RegexpQuery regexQuery = new RegexpQuery(new Term(field, content.getStringValue()));
                    regexQuery.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
                    return regexQuery;
                }
            }
        }
        if (operator == RangeIndex.Operator.EQ) {
            return new TermQuery(new Term(field, RangeIndexConfigElement.convertToBytes(content)));
        }
        if (operator == RangeIndex.Operator.NE) {
            BooleanQuery nq = new BooleanQuery();
            nq.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            nq.add((Query)new TermQuery(new Term(field, RangeIndexConfigElement.convertToBytes(content))), BooleanClause.Occur.MUST_NOT);
            return nq;
        }
        boolean includeUpper = operator == RangeIndex.Operator.LE;
        boolean includeLower = operator == RangeIndex.Operator.GE;
        switch (type) {
            case 31: 
            case 37: 
            case 42: {
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newLongRange((String)field, null, (Long)((NumericValue)content).getLong(), (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newLongRange((String)field, (Long)((NumericValue)content).getLong(), null, (boolean)includeLower, (boolean)includeUpper);
            }
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newIntRange((String)field, null, (Integer)((NumericValue)content).getInt(), (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newIntRange((String)field, (Integer)((NumericValue)content).getInt(), null, (boolean)includeLower, (boolean)includeUpper);
            }
            case 32: 
            case 34: {
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newDoubleRange((String)field, null, (Double)((NumericValue)content).getDouble(), (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newDoubleRange((String)field, (Double)((NumericValue)content).getDouble(), null, (boolean)includeLower, (boolean)includeUpper);
            }
            case 33: {
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newFloatRange((String)field, null, (Float)Float.valueOf((float)((NumericValue)content).getDouble()), (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newFloatRange((String)field, (Float)Float.valueOf((float)((NumericValue)content).getDouble()), null, (boolean)includeLower, (boolean)includeUpper);
            }
            case 51: {
                long dl = RangeIndexConfigElement.dateToLong((DateValue)content);
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newLongRange((String)field, null, (Long)dl, (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newLongRange((String)field, (Long)dl, null, (boolean)includeLower, (boolean)includeUpper);
            }
            case 52: {
                long tl = RangeIndexConfigElement.timeToLong((TimeValue)content);
                if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
                    return NumericRangeQuery.newLongRange((String)field, null, (Long)tl, (boolean)includeLower, (boolean)includeUpper);
                }
                return NumericRangeQuery.newLongRange((String)field, (Long)tl, null, (boolean)includeLower, (boolean)includeUpper);
            }
        }
        if (type == 50) {
            key = RangeIndexConfigElement.convertToBytes(content);
        }
        if (operator == RangeIndex.Operator.LT || operator == RangeIndex.Operator.LE) {
            return new TermRangeQuery(field, null, key, includeLower, includeUpper);
        }
        return new TermRangeQuery(field, key, null, includeLower, includeUpper);
    }

    public String getIndexId() {
        return this.index.getIndexId();
    }

    public String getIndexName() {
        return this.index.getIndexName();
    }

    public Object configure(IndexController controller, NodeList configNodes, Map<String, String> namespaces) throws DatabaseConfigurationException {
        this.controller = controller;
        LOG.debug("Configuring lucene index...");
        return new RangeIndexConfig(configNodes, namespaces);
    }

    public void setDocument(DocumentImpl document) {
        this.setDocument(document, StreamListener.ReindexMode.UNKNOWN);
    }

    public void setDocument(DocumentImpl document, StreamListener.ReindexMode mode) {
        this.currentDoc = document;
        IndexSpec indexConf = document.getCollection().getIndexConfiguration(this.broker);
        if (indexConf != null) {
            this.config = (RangeIndexConfig)indexConf.getCustomIndexSpec(RangeIndex.ID);
            if (this.config != null) {
                this.config = new RangeIndexConfig(this.config);
            }
        }
        this.mode = mode;
    }

    public void setMode(StreamListener.ReindexMode mode) {
        this.mode = mode;
        switch (mode) {
            case STORE: {
                if (this.nodesToWrite == null) {
                    this.nodesToWrite = new ArrayList<RangeIndexDoc>();
                } else {
                    this.nodesToWrite.clear();
                }
                this.cachedNodesSize = 0;
                break;
            }
            case REMOVE_SOME_NODES: {
                this.nodesToRemove = new TreeSet<NodeId>();
            }
        }
    }

    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    public StreamListener.ReindexMode getMode() {
        return this.mode;
    }

    public <T extends IStoredNode> IStoredNode getReindexRoot(IStoredNode<T> node, NodePath path, boolean insert, boolean includeSelf) {
        if (this.config == null) {
            return null;
        }
        NodePath p = new NodePath(path);
        boolean reindexRequired = false;
        if (node.getNodeType() == 1 && !includeSelf) {
            p.removeLastComponent();
        }
        while (p.length() > 0) {
            if (this.config.matches(p)) {
                reindexRequired = true;
                break;
            }
            p.removeLastComponent();
        }
        if (reindexRequired) {
            p = new NodePath(path);
            IStoredNode topMost = null;
            IStoredNode currentNode = node;
            if (currentNode.getNodeType() != 1) {
                currentNode = currentNode.getParentStoredNode();
            }
            while (currentNode != null) {
                if (this.config.matches(p)) {
                    topMost = currentNode;
                }
                currentNode = currentNode.getParentStoredNode();
                p.removeLastComponent();
            }
            return topMost;
        }
        return null;
    }

    public QueryRewriter getQueryRewriter(XQueryContext context) {
        return new RangeQueryRewriter(context);
    }

    public StreamListener getListener() {
        return this.listener;
    }

    public MatchListener getMatchListener(DBBroker broker, NodeProxy proxy) {
        return null;
    }

    public void flush() {
        switch (this.mode) {
            case STORE: {
                this.write();
                break;
            }
            case REMOVE_SOME_NODES: {
                this.removeNodes();
                break;
            }
            case REMOVE_ALL_NODES: {
                this.removeDocument(this.currentDoc.getDocId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(Collection collection, DBBroker broker, boolean reindex) throws PermissionDeniedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing collection " + collection.getURI());
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                BytesRefBuilder bytes = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)doc.getDocId(), (int)0, (BytesRefBuilder)bytes);
                Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
                writer.deleteDocuments(new Term[]{dt});
            }
        }
        catch (IOException | PermissionDeniedException | LockException e) {
            LOG.error("Error while removing lucene index: " + e.getMessage(), e);
        }
        finally {
            this.index.releaseWriter(writer);
            if (reindex) {
                try {
                    this.index.sync();
                }
                catch (DBException e) {
                    LOG.warn("Exception during reindex: " + e.getMessage(), (Throwable)e);
                }
            }
            this.mode = StreamListener.ReindexMode.STORE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collection removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(int docId) {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            BytesRefBuilder bytes = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)docId, (int)0, (BytesRefBuilder)bytes);
            Term dt = new Term(FIELD_DOC_ID, bytes.toBytesRef());
            writer.deleteDocuments(new Term[]{dt});
        }
        catch (IOException e) {
            LOG.warn("Error while removing lucene index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.mode = StreamListener.ReindexMode.STORE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNodes() {
        if (this.nodesToRemove == null) {
            return;
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            for (NodeId nodeId : this.nodesToRemove) {
                int nodeIdLen = nodeId.size();
                byte[] data = new byte[nodeIdLen + 4];
                ByteConversion.intToByteH((int)this.currentDoc.getDocId(), (byte[])data, (int)0);
                nodeId.serialize(data, 4);
                Term it = new Term(FIELD_ID, new BytesRef(data));
                TermQuery iq = new TermQuery(it);
                writer.deleteDocuments(new Query[]{iq});
            }
        }
        catch (IOException e) {
            LOG.warn("Error while deleting lucene index entries: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.nodesToRemove = null;
            this.index.releaseWriter(writer);
        }
    }

    public boolean checkIndex(DBBroker broker) {
        return false;
    }

    protected void indexText(NodeHandle nodeHandle, QName qname, NodePath path, RangeIndexConfigElement config, TextCollector collector) {
        RangeIndexDoc pending = new RangeIndexDoc(nodeHandle.getNodeId(), qname, path, collector, config);
        pending.setAddress(nodeHandle.getInternalAddress());
        this.nodesToWrite.add(pending);
        this.cachedNodesSize += collector.length();
        if (this.cachedNodesSize > this.maxCachedNodesSize) {
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        if (this.nodesToWrite == null || this.nodesToWrite.size() == 0) {
            return;
        }
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter();
            IntDocValuesField fDocId = new IntDocValuesField(FIELD_DOC_ID, 0);
            BinaryDocValuesField fNodeId = new BinaryDocValuesField(FIELD_NODE_ID, new BytesRef(8));
            BinaryDocValuesField fAddress = new BinaryDocValuesField(FIELD_ADDRESS, new BytesRef(8));
            IntField fDocIdIdx = new IntField(FIELD_DOC_ID, 0, IntField.TYPE_NOT_STORED);
            for (RangeIndexDoc pending : this.nodesToWrite) {
                Document doc = new Document();
                fDocId.setIntValue(this.currentDoc.getDocId());
                doc.add((IndexableField)fDocId);
                int nodeIdLen = pending.getNodeId().size();
                byte[] data = new byte[nodeIdLen + 2];
                ByteConversion.shortToByte((short)((short)pending.getNodeId().units()), (byte[])data, (int)0);
                pending.getNodeId().serialize(data, 2);
                fNodeId.setBytesValue(data);
                doc.add((IndexableField)fNodeId);
                if (pending.getCollector().hasFields() && pending.getAddress() != -1L) {
                    fAddress.setBytesValue(ByteConversion.longToByte((long)pending.getAddress()));
                    doc.add((IndexableField)fAddress);
                }
                byte[] idData = new byte[nodeIdLen + 4];
                ByteConversion.intToByteH((int)this.currentDoc.getDocId(), (byte[])idData, (int)0);
                pending.getNodeId().serialize(idData, 4);
                BinaryTokenStream bts = new BinaryTokenStream(new BytesRef(idData));
                Field fNodeIdIdx = new Field(FIELD_ID, (TokenStream)bts, LuceneIndexWorker.TYPE_NODE_ID);
                doc.add((IndexableField)fNodeIdIdx);
                for (TextCollector.Field field : pending.getCollector().getFields()) {
                    String contentField = field.isNamed() ? field.getName() : LuceneUtil.encodeQName((QName)pending.getQName(), (SymbolTable)this.index.getBrokerPool().getSymbols());
                    Field fld = pending.getConfig().convertToField(contentField, field.getContent().toString());
                    if (fld == null) continue;
                    doc.add((IndexableField)fld);
                }
                fDocIdIdx.setIntValue(this.currentDoc.getDocId());
                doc.add((IndexableField)fDocIdIdx);
                Analyzer analyzer = pending.getConfig().getAnalyzer();
                if (analyzer == null) {
                    analyzer = this.config.getDefaultAnalyzer();
                }
                writer.addDocument((Iterable)doc, analyzer);
            }
        }
        catch (IOException e) {
            LOG.warn("An exception was caught while indexing document: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
            this.nodesToWrite = new ArrayList<RangeIndexDoc>();
            this.cachedNodesSize = 0;
        }
    }

    public NodeSet query(int contextId, DocumentSet docs, NodeSet contextSet, List<QName> qnames, AtomicValue[] keys, RangeIndex.Operator operator, int axis) throws IOException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            List<QName> definedIndexes = this.getDefinedIndexes(qnames);
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            for (QName qname : definedIndexes) {
                short nodeType;
                Query query;
                String field = LuceneUtil.encodeQName((QName)qname, (SymbolTable)this.index.getBrokerPool().getSymbols());
                if (keys.length > 1) {
                    BooleanQuery bool = new BooleanQuery();
                    for (AtomicValue key : keys) {
                        bool.add(this.toQuery(field, qname, key, operator, docs), BooleanClause.Occur.SHOULD);
                    }
                    query = bool;
                } else {
                    query = this.toQuery(field, qname, keys[0], operator, docs);
                }
                short s = nodeType = qname.getNameType() == 1 ? (short)2 : (short)1;
                if (contextSet != null && contextSet.hasOne() && contextSet.getItemType() != 6) {
                    NodesFilter filter = new NodesFilter(contextSet);
                    filter.init(searcher.getIndexReader());
                    FilteredQuery filtered = new FilteredQuery(query, (Filter)filter, FilteredQuery.LEAP_FROG_FILTER_FIRST_STRATEGY);
                    resultSet.addAll(this.doQuery(contextId, docs, contextSet, axis, (IndexSearcher)searcher, nodeType, (Query)filtered, null));
                    continue;
                }
                resultSet.addAll(this.doQuery(contextId, docs, contextSet, axis, (IndexSearcher)searcher, nodeType, query, null));
            }
            return resultSet;
        });
    }

    public NodeSet queryField(int contextId, DocumentSet docs, NodeSet contextSet, Sequence fields, Sequence[] keys, RangeIndex.Operator[] operators, int axis) throws IOException, XPathException {
        return (NodeSet)this.index.withSearcher(searcher -> {
            BooleanQuery query = new BooleanQuery();
            int j = 0;
            SequenceIterator i = fields.iterate();
            while (i.hasNext()) {
                String field = i.nextItem().getStringValue();
                if (keys[j].getItemCount() > 1) {
                    BooleanQuery bool = new BooleanQuery();
                    bool.setMinimumNumberShouldMatch(1);
                    SequenceIterator ki = keys[j].iterate();
                    while (ki.hasNext()) {
                        Item key = ki.nextItem();
                        Query q = this.toQuery(field, null, key.atomize(), operators[j], docs);
                        bool.add(q, BooleanClause.Occur.SHOULD);
                    }
                    query.add((Query)bool, BooleanClause.Occur.MUST);
                } else {
                    Query q = this.toQuery(field, null, keys[j].itemAt(0).atomize(), operators[j], docs);
                    query.add(q, BooleanClause.Occur.MUST);
                }
                ++j;
            }
            BooleanQuery qu = query;
            BooleanClause[] clauses = query.getClauses();
            if (clauses.length == 1) {
                qu = clauses[0].getQuery();
            }
            NewArrayNodeSet resultSet = new NewArrayNodeSet();
            if (contextSet != null && contextSet.hasOne() && contextSet.getItemType() != 6) {
                NodesFilter filter = new NodesFilter(contextSet);
                filter.init(searcher.getIndexReader());
                FilteredQuery filtered = new FilteredQuery((Query)qu, (Filter)filter, FilteredQuery.LEAP_FROG_FILTER_FIRST_STRATEGY);
                resultSet.addAll(this.doQuery(contextId, docs, contextSet, axis, (IndexSearcher)searcher, (short)1, (Query)filtered, null));
            } else {
                resultSet.addAll(this.doQuery(contextId, docs, contextSet, axis, (IndexSearcher)searcher, (short)1, (Query)qu, null));
            }
            return resultSet;
        });
    }

    private NodeSet doQuery(int contextId, DocumentSet docs, NodeSet contextSet, int axis, IndexSearcher searcher, short nodeType, Query query, Filter filter) throws IOException {
        SearchCollector collector = new SearchCollector(docs, contextSet, nodeType, axis, contextId);
        searcher.search(query, filter, (Collector)collector);
        return collector.getResultSet();
    }

    private List<QName> getDefinedIndexes(List<QName> qnames) throws IOException {
        ArrayList<QName> indexes = new ArrayList<QName>(20);
        if (qnames != null && !qnames.isEmpty()) {
            for (QName qname : qnames) {
                if (qname.getLocalPart() == null || qname.getNamespaceURI() == null) {
                    this.getDefinedIndexesFor(qname, indexes);
                    continue;
                }
                indexes.add(qname);
            }
            return indexes;
        }
        return this.getDefinedIndexesFor(null, indexes);
    }

    private List<QName> getDefinedIndexesFor(QName qname, List<QName> indexes) throws IOException {
        return (List)this.index.withReader(reader -> {
            for (FieldInfo info : MultiFields.getMergedFieldInfos((IndexReader)reader)) {
                QName name;
                if (FIELD_DOC_ID.equals(info.name) || (name = LuceneUtil.decodeQName((String)info.name, (SymbolTable)this.index.getBrokerPool().getSymbols())) == null || qname != null && !RangeIndexWorker.matchQName(qname, name)) continue;
                indexes.add(name);
            }
            return indexes;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesRef analyzeContent(String field, QName qname, String data, DocumentSet docs) throws XPathException {
        Analyzer analyzer = this.getAnalyzer(qname, field, docs);
        if (!this.isCaseSensitive(qname, field, docs)) {
            data = data.toLowerCase();
        }
        if (analyzer == null) {
            return new BytesRef((CharSequence)data);
        }
        try {
            TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(data));
            TermToBytesRefAttribute termAttr = (TermToBytesRefAttribute)stream.addAttribute(TermToBytesRefAttribute.class);
            BytesRef token = null;
            try {
                stream.reset();
                if (stream.incrementToken()) {
                    termAttr.fillBytesRef();
                    token = BytesRef.deepCopyOf((BytesRef)termAttr.getBytesRef());
                }
                stream.end();
            }
            finally {
                stream.close();
            }
            return token;
        }
        catch (IOException e) {
            throw new XPathException("Error analyzing the query string: " + e.getMessage(), (Throwable)e);
        }
    }

    private Analyzer getAnalyzer(QName qname, String fieldName, DocumentSet docs) {
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Analyzer analyzer;
            RangeIndexConfig config;
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(this.broker);
            if (idxConf == null || (config = (RangeIndexConfig)idxConf.getCustomIndexSpec(RangeIndex.ID)) == null || (analyzer = config.getAnalyzer(qname, fieldName)) == null) continue;
            return analyzer;
        }
        return null;
    }

    private boolean isCaseSensitive(QName qname, String fieldName, DocumentSet docs) {
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            RangeIndexConfig config;
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(this.broker);
            if (idxConf == null || (config = (RangeIndexConfig)idxConf.getCustomIndexSpec(RangeIndex.ID)) == null || config.isCaseSensitive(qname, fieldName)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchQName(QName qname, QName candidate) {
        boolean match = true;
        if (qname.getLocalPart() != null) {
            match = qname.getLocalPart().equals(candidate.getLocalPart());
        }
        if (match && qname.getNamespaceURI() != null && qname.getNamespaceURI().length() > 0) {
            match = qname.getNamespaceURI().equals(candidate.getNamespaceURI());
        }
        return match;
    }

    public void optimize() {
        IndexWriter writer = null;
        try {
            writer = this.index.getWriter(true);
            writer.forceMerge(1, true);
            writer.commit();
        }
        catch (IOException e) {
            LOG.warn("An exception was caught while optimizing the lucene index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.index.releaseWriter(writer);
        }
    }

    public Occurrences[] scanIndex(XQueryContext context, DocumentSet docs, NodeSet nodes, Map hints) {
        try {
            List<QName> qnames = hints == null ? null : (List<QName>)hints.get("qnames_key");
            qnames = this.getDefinedIndexes(qnames);
            String start = null;
            String end = null;
            long max = Long.MAX_VALUE;
            if (hints != null) {
                Object vstart = hints.get("start_value");
                Object vend = hints.get("end_value");
                start = vstart == null ? null : vstart.toString();
                end = vend == null ? null : vend.toString();
                IntegerValue vmax = (IntegerValue)hints.get("value_count");
                max = vmax == null ? Long.MAX_VALUE : vmax.getValue();
            }
            return this.scanIndexByQName(qnames, docs, nodes, start, end, max);
        }
        catch (IOException e) {
            LOG.warn("Failed to scan index: " + e.getMessage(), (Throwable)e);
            return new Occurrences[0];
        }
    }

    public Occurrences[] scanIndexByField(String field, DocumentSet docs, String start, long max) {
        try {
            return (Occurrences[])this.index.withReader(reader -> {
                TreeMap<String, Occurrences> map = new TreeMap<String, Occurrences>();
                this.scan(docs, null, start, null, max, map, (IndexReader)reader, field);
                Occurrences[] occur = new Occurrences[map.size()];
                return map.values().toArray(occur);
            });
        }
        catch (IOException e) {
            LOG.warn("Failed to scan index: " + e.getMessage(), (Throwable)e);
            return new Occurrences[0];
        }
    }

    private Occurrences[] scanIndexByQName(List<QName> qnames, DocumentSet docs, NodeSet nodes, String start, String end, long max) throws IOException {
        return (Occurrences[])this.index.withReader(reader -> {
            TreeMap<String, Occurrences> map = new TreeMap<String, Occurrences>();
            for (QName qname : qnames) {
                String field = LuceneUtil.encodeQName((QName)qname, (SymbolTable)this.index.getBrokerPool().getSymbols());
                this.scan(docs, nodes, start, end, max, map, (IndexReader)reader, field);
            }
            Occurrences[] occur = new Occurrences[map.size()];
            return map.values().toArray(occur);
        });
    }

    private void scan(DocumentSet docs, NodeSet nodes, String start, String end, long max, TreeMap<String, Occurrences> map, IndexReader reader, String field) throws IOException {
        List leaves = reader.leaves();
        block0: for (AtomicReaderContext context : leaves) {
            TermsEnum termsIter;
            NumericDocValues docIdValues = context.reader().getNumericDocValues(FIELD_DOC_ID);
            BinaryDocValues nodeIdValues = context.reader().getBinaryDocValues(FIELD_NODE_ID);
            Bits liveDocs = context.reader().getLiveDocs();
            Terms terms = context.reader().terms(field);
            if (terms == null || (termsIter = terms.iterator(null)).next() == null) continue;
            while ((long)map.size() < max) {
                BytesRef ref = termsIter.term();
                String term = ref.utf8ToString();
                boolean include = true;
                if (end != null) {
                    if (term.compareTo(end) > 0) {
                        include = false;
                    }
                } else if (start != null && !term.startsWith(start)) {
                    include = false;
                }
                if (include) {
                    DocsEnum docsEnum = termsIter.docs(null, null);
                    while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                        int docId;
                        DocumentImpl storedDocument;
                        if (liveDocs != null && !liveDocs.get(docsEnum.docID()) || (storedDocument = docs.getDoc(docId = (int)docIdValues.get(docsEnum.docID()))) == null) continue;
                        NodeId nodeId = null;
                        if (nodes != null) {
                            BytesRef nodeIdRef = nodeIdValues.get(docsEnum.docID());
                            short units = ByteConversion.byteToShort((byte[])nodeIdRef.bytes, (int)nodeIdRef.offset);
                            nodeId = this.index.getBrokerPool().getNodeFactory().createFromData((int)units, nodeIdRef.bytes, nodeIdRef.offset + 2);
                        }
                        if (nodeId != null && nodes.get(storedDocument, nodeId) == null) continue;
                        Occurrences oc = map.get(term);
                        if (oc == null) {
                            oc = new Occurrences((Comparable)((Object)term));
                            map.put(term, oc);
                        }
                        oc.addDocument(storedDocument);
                        oc.addOccurrences(docsEnum.freq());
                    }
                }
                if (termsIter.next() != null) continue;
                continue block0;
            }
        }
    }

    static {
        LOAD_FIELDS.add(FIELD_DOC_ID);
        LOAD_FIELDS.add(FIELD_NODE_ID);
    }

    private class RangeIndexListener
    extends AbstractStreamListener {
        private RangeIndexListener() {
        }

        public void startElement(Txn transaction, ElementImpl element, NodePath path) {
            if (RangeIndexWorker.this.mode == StreamListener.ReindexMode.STORE && RangeIndexWorker.this.config != null) {
                Iterator<RangeIndexConfigElement> configIter;
                if (RangeIndexWorker.this.contentStack != null && !RangeIndexWorker.this.contentStack.isEmpty()) {
                    for (TextCollector extractor : RangeIndexWorker.this.contentStack) {
                        extractor.startElement(element.getQName(), path);
                    }
                }
                if ((configIter = RangeIndexWorker.this.config.getConfig(path)) != null) {
                    if (RangeIndexWorker.this.contentStack == null) {
                        RangeIndexWorker.this.contentStack = new Stack();
                    }
                    while (configIter.hasNext()) {
                        RangeIndexConfigElement configuration = configIter.next();
                        if (!configuration.match(path)) continue;
                        TextCollector collector = configuration.getCollector(path);
                        collector.startElement(element.getQName(), path);
                        RangeIndexWorker.this.contentStack.push(collector);
                    }
                }
            }
            super.startElement(transaction, element, path);
        }

        public void attribute(Txn transaction, AttrImpl attrib, NodePath path) {
            path.addComponent(attrib.getQName());
            if (RangeIndexWorker.this.contentStack != null && !RangeIndexWorker.this.contentStack.isEmpty()) {
                for (TextCollector collector : RangeIndexWorker.this.contentStack) {
                    collector.attribute(attrib, path);
                }
            }
            Iterator<RangeIndexConfigElement> configIter = null;
            if (RangeIndexWorker.this.config != null) {
                configIter = RangeIndexWorker.this.config.getConfig(path);
            }
            if (RangeIndexWorker.this.mode != StreamListener.ReindexMode.REMOVE_ALL_NODES && configIter != null) {
                if (RangeIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                    RangeIndexWorker.this.nodesToRemove.add(attrib.getNodeId());
                } else {
                    while (configIter.hasNext()) {
                        RangeIndexConfigElement configuration = configIter.next();
                        if (!configuration.match(path)) continue;
                        SimpleTextCollector collector = new SimpleTextCollector(attrib.getValue());
                        RangeIndexWorker.this.indexText((NodeHandle)attrib, attrib.getQName(), path, configuration, collector);
                    }
                }
            }
            path.removeLastComponent();
            super.attribute(transaction, attrib, path);
        }

        public void endElement(Txn transaction, ElementImpl element, NodePath path) {
            if (RangeIndexWorker.this.config != null) {
                if (RangeIndexWorker.this.mode == StreamListener.ReindexMode.STORE && RangeIndexWorker.this.contentStack != null && !RangeIndexWorker.this.contentStack.isEmpty()) {
                    for (TextCollector extractor : RangeIndexWorker.this.contentStack) {
                        extractor.endElement(element.getQName(), path);
                    }
                }
                Iterator<RangeIndexConfigElement> configIter = RangeIndexWorker.this.config.getConfig(path);
                if (RangeIndexWorker.this.mode != StreamListener.ReindexMode.REMOVE_ALL_NODES && configIter != null) {
                    if (RangeIndexWorker.this.mode == StreamListener.ReindexMode.REMOVE_SOME_NODES) {
                        RangeIndexWorker.this.nodesToRemove.add(element.getNodeId());
                    } else {
                        while (configIter.hasNext()) {
                            RangeIndexConfigElement configuration = configIter.next();
                            boolean match = configuration.match(path);
                            if (!match) continue;
                            TextCollector collector = (TextCollector)RangeIndexWorker.this.contentStack.pop();
                            boolean bl = collector instanceof ComplexTextCollector ? match && ((ComplexTextCollector)collector).getConfig().matchConditions((Node)element) : match;
                            match = bl;
                            if (!match) continue;
                            RangeIndexWorker.this.indexText((NodeHandle)element, element.getQName(), path, configuration, collector);
                        }
                    }
                }
            }
            super.endElement(transaction, element, path);
        }

        public void characters(Txn transaction, AbstractCharacterData text, NodePath path) {
            if (RangeIndexWorker.this.contentStack != null && !RangeIndexWorker.this.contentStack.isEmpty()) {
                for (TextCollector collector : RangeIndexWorker.this.contentStack) {
                    collector.characters(text, path);
                }
            }
            super.characters(transaction, text, path);
        }

        public IndexWorker getWorker() {
            return RangeIndexWorker.this;
        }
    }

    private class SearchCollector
    extends Collector {
        private final NodeSet resultSet;
        private final NodeSet contextSet;
        private final short nodeType;
        private final int axis;
        private final int contextId;
        private final DocumentSet docs;
        private AtomicReader reader;
        private NumericDocValues docIdValues;
        private BinaryDocValues nodeIdValues;
        private BinaryDocValues addressValues;
        private final byte[] buf = new byte[1024];

        public SearchCollector(DocumentSet docs, NodeSet contextSet, short nodeType, int axis, int contextId) {
            this.resultSet = new NewArrayNodeSet();
            this.docs = docs;
            this.contextSet = contextSet;
            this.nodeType = nodeType;
            this.axis = axis;
            this.contextId = contextId;
        }

        public NodeSet getResultSet() {
            return this.resultSet;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            int docId = (int)this.docIdValues.get(doc);
            DocumentImpl storedDocument = this.docs.getDoc(docId);
            if (storedDocument == null) {
                return;
            }
            BytesRef ref = this.nodeIdValues.get(doc);
            short units = ByteConversion.byteToShort((byte[])ref.bytes, (int)ref.offset);
            NodeId nodeId = RangeIndexWorker.this.index.getBrokerPool().getNodeFactory().createFromData((int)units, ref.bytes, ref.offset + 2);
            if (this.contextSet != null) {
                int sizeHint = this.contextSet.getSizeHint(storedDocument);
                NodeProxy parentNode = this.contextSet.parentWithChild(storedDocument, nodeId, false, true);
                if (parentNode != null) {
                    NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                    storedNode.setNodeType(this.nodeType);
                    this.getAddress(doc, (NodeHandle)storedNode);
                    if (this.axis == 0) {
                        this.resultSet.add(parentNode, sizeHint);
                        if (-1 != this.contextId) {
                            parentNode.deepCopyContext(storedNode, this.contextId);
                        } else {
                            parentNode.copyContext(storedNode);
                        }
                    } else {
                        this.resultSet.add(storedNode, sizeHint);
                    }
                }
            } else {
                NodeProxy storedNode = new NodeProxy(storedDocument, nodeId);
                storedNode.setNodeType(this.nodeType);
                this.getAddress(doc, (NodeHandle)storedNode);
                this.resultSet.add(storedNode);
            }
        }

        private void getAddress(int doc, NodeHandle storedNode) {
            if (this.addressValues != null) {
                BytesRef ref = this.addressValues.get(doc);
                if (ref.offset < ref.bytes.length) {
                    long address = ByteConversion.byteToLong((byte[])ref.bytes, (int)ref.offset);
                    storedNode.setInternalAddress(address);
                }
            }
        }

        public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
            this.reader = atomicReaderContext.reader();
            this.docIdValues = this.reader.getNumericDocValues(RangeIndexWorker.FIELD_DOC_ID);
            this.nodeIdValues = this.reader.getBinaryDocValues(RangeIndexWorker.FIELD_NODE_ID);
            this.addressValues = this.reader.getBinaryDocValues(RangeIndexWorker.FIELD_ADDRESS);
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

