/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range;

import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.storage.NodePath;
import org.exist.util.XMLString;

public interface TextCollector {
    public void startElement(QName var1, NodePath var2);

    public void endElement(QName var1, NodePath var2);

    public void characters(AbstractCharacterData var1, NodePath var2);

    public void attribute(AttrImpl var1, NodePath var2);

    public int length();

    public List<Field> getFields();

    public boolean hasFields();

    public static class Field {
        protected final boolean attribute;
        protected final String name;
        protected final int wsTreatment;
        protected final boolean caseSensitive;
        protected XMLString content;

        public Field(XMLString content, int wsTreatment, boolean caseSensitive) {
            this.content = content;
            this.attribute = false;
            this.name = null;
            this.wsTreatment = wsTreatment;
            this.caseSensitive = caseSensitive;
        }

        public Field(String name, boolean isAttribute, int wsTreatment, boolean caseSensitive) {
            this.name = name;
            this.attribute = isAttribute;
            this.wsTreatment = wsTreatment;
            this.content = new XMLString();
            this.caseSensitive = caseSensitive;
        }

        public String getContent() {
            if (!this.caseSensitive) {
                this.content = this.content.transformToLower();
            }
            if (this.wsTreatment != 0) {
                return this.content.normalize(this.wsTreatment).toString();
            }
            return this.content.toString();
        }

        public String getName() {
            return this.name;
        }

        public boolean isNamed() {
            return this.name != null;
        }

        public boolean isAttribute() {
            return this.attribute;
        }
    }
}

