/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing.range.conversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.indexing.range.conversion.TypeConverter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.TimeUtils;

public class DateConverter
implements TypeConverter {
    protected static final Logger LOG = LogManager.getLogger(DateConverter.class);
    private static final Pattern DATE_REGEX = Pattern.compile("(-?\\d+)-(\\d+)-(\\d+)");

    @Override
    public Field toField(String fieldName, String content) {
        try {
            DateValue dv;
            if (content.indexOf(45) < 1) {
                int year = Integer.parseInt(content);
                XMLGregorianCalendar calendar = TimeUtils.getInstance().newXMLGregorianCalendar();
                calendar.setYear(year);
                calendar.setDay(1);
                calendar.setMonth(1);
                dv = new DateValue(calendar);
            } else {
                Matcher matcher = DATE_REGEX.matcher(content);
                if (matcher.matches()) {
                    try {
                        int year = Integer.parseInt(matcher.group(1));
                        content = (year < 0 ? "-" : "") + String.format("%04d-%02d-%02d", Math.abs(year), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                dv = new DateValue(content);
            }
            long dl = RangeIndexConfigElement.dateToLong(dv);
            return new LongField(fieldName, dl, LongField.TYPE_NOT_STORED);
        }
        catch (XPathException e) {
            LOG.debug("Invalid date format: " + content, (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.debug("Invalid date format: " + content, (Throwable)e);
        }
        catch (Exception e) {
            LOG.debug("Invalid date format: " + content, (Throwable)e);
        }
        return null;
    }
}

