/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.indexing.range.RangeIndex;
import org.exist.indexing.range.RangeIndexConfig;
import org.exist.indexing.range.RangeIndexConfigElement;
import org.exist.indexing.range.RangeIndexWorker;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.range.RangeIndexModule;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Lookup
extends Function
implements Optimizable {
    private static final SequenceType[] PARAMETER_TYPE = new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 7, "The node set to search using a range index which is defined on those nodes"), new FunctionParameterSequenceType("key", 20, 7, "The key to look up.")};
    private static final String DESCRIPTION = "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("eq", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("gt", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("lt", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("le", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("ge", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("ne", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is not equal to the key.")), new FunctionSignature(new QName("starts-with", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("ends-with", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("contains", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", PARAMETER_TYPE, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value is equal to the key.")), new FunctionSignature(new QName("matches", "http://exist-db.org/xquery/range", "range"), "Search for nodes matching the given keys in the range index. Normally this function will be called by the query optimizer.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 7, "The node set to search using a range index which is defined on those nodes"), new FunctionParameterSequenceType("regex", 22, 7, "The regular expression.")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "all nodes from the input node set whose node value matches the regular expression. Regular expression syntax is limited to what Lucene supports. See http://lucene.apache.org/core/4_5_1/core/org/apache/lucene/util/automaton/RegExp.html"))};
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected int axis = -1;
    private NodeSet preselectResult = null;
    protected boolean canOptimize = false;
    protected boolean optimizeSelf = false;
    protected boolean optimizeChild = false;
    protected boolean usesCollation = false;
    protected Expression fallback = null;
    protected NodePath contextPath = null;

    public static Lookup create(XQueryContext context, RangeIndex.Operator operator, NodePath contextPath) {
        for (FunctionSignature sig : signatures) {
            if (!sig.getName().getLocalPart().equals(operator.toString())) continue;
            return new Lookup(context, sig, contextPath);
        }
        return null;
    }

    public Lookup(XQueryContext context, FunctionSignature signature) {
        this(context, signature, null);
    }

    public Lookup(XQueryContext context, FunctionSignature signature, NodePath contextPath) {
        super(context, signature);
        this.contextPath = contextPath;
    }

    public void setFallback(Expression expression, int optimizeAxis) {
        if (expression instanceof InternalFunctionCall) {
            expression = ((InternalFunctionCall)expression).getFunction();
        }
        this.fallback = expression;
        this.axis = optimizeAxis;
    }

    public Expression getFallback() {
        return this.fallback;
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        this.steps.clear();
        Expression path = arguments.get(0);
        this.steps.add(path);
        Expression arg = arguments.get(1).simplify();
        arg = new DynamicCardinalityCheck(this.context, 7, arg, new Error("D02", (Object)"2", (Object)this.mySignature));
        this.steps.add(arg);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(new AnalyzeContextInfo(contextInfo));
        List steps = BasicExpressionVisitor.findLocationSteps((Expression)this.getArgument(0));
        if (!steps.isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (firstStep != null && steps.size() == 1 && firstStep.getAxis() == 12) {
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep) {
                    LocationStep outerStep = (LocationStep)outerExpr;
                    NodeTest test = outerStep.getTest();
                    this.contextQName = test.getName() == null ? new QName(null, null, null) : (test.isWildcardTest() ? test.getName() : new QName(test.getName()));
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName = new QName(this.contextQName.getLocalPart(), this.contextQName.getNamespaceURI(), this.contextQName.getPrefix(), 1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else if (lastStep != null && firstStep != null) {
                NodeTest test = lastStep.getTest();
                this.contextQName = test.getName() == null ? new QName(null, null, null) : (test.isWildcardTest() ? test.getName() : new QName(test.getName()));
                if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                    this.contextQName = new QName(this.contextQName.getLocalPart(), this.contextQName.getNamespaceURI(), this.contextQName.getPrefix(), 1);
                }
                this.axis = firstStep.getAxis();
                this.optimizeChild = steps.size() == 1 && (this.axis == 5 || this.axis == 6);
                this.contextStep = lastStep;
            }
        }
        if (this.fallback != null) {
            AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.setStaticType(-1);
            this.fallback.analyze(newContextInfo);
        }
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        if (!this.canOptimize) {
            return ((Optimizable)this.fallback).preSelect(contextSequence, useContext);
        }
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            return NodeSet.EMPTY_SET;
        }
        RangeIndex.Operator operator = this.getOperator();
        if (this.usesCollation && !operator.supportsCollation()) {
            throw new XPathException((Expression)this, RangeIndexModule.EXXQDYFT0001, "Index defines a collation which cannot be used with the '" + (Object)((Object)operator) + "' operation.");
        }
        long start = System.currentTimeMillis();
        this.preselectResult = null;
        RangeIndexWorker index = (RangeIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(RangeIndex.ID);
        DocumentSet docs = contextSequence.getDocumentSet();
        AtomicValue[] keys = this.getKeys(contextSequence);
        if (keys.length == 0) {
            return NodeSet.EMPTY_SET;
        }
        ArrayList<QName> qnames = null;
        if (this.contextQName != null) {
            qnames = new ArrayList<QName>(1);
            qnames.add(this.contextQName);
        }
        try {
            this.preselectResult = index.query(this.getExpressionId(), docs, contextSequence.toNodeSet(), qnames, keys, operator, 1);
        }
        catch (IOException | XPathException e) {
            throw new XPathException((Expression)this, "Error while querying full text index: " + e.getMessage(), e);
        }
        if (this.context.getProfiler().traceFunctions()) {
            this.context.getProfiler().traceIndexUsage(this.context, "new-range", (Expression)this, 2, System.currentTimeMillis() - start);
        }
        if (this.preselectResult == null) {
            this.preselectResult = NodeSet.EMPTY_SET;
        }
        return this.preselectResult;
    }

    private RangeIndex.Operator getOperator() {
        String calledAs = this.getSignature().getName().getLocalPart();
        return RangeIndexModule.OPERATOR_MAP.get(calledAs);
    }

    private AtomicValue[] getKeys(Sequence contextSequence) throws XPathException {
        RangeIndexConfigElement config = this.findConfiguration(contextSequence);
        int targetType = config != null ? config.getType() : 11;
        Sequence keySeq = Atomize.atomize((Sequence)this.getArgument(1).eval(contextSequence));
        AtomicValue[] keys = new AtomicValue[keySeq.getItemCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = targetType == 11 ? (AtomicValue)keySeq.itemAt(i) : keySeq.itemAt(i).convertTo(targetType);
        }
        return keys;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (!this.canOptimize && this.fallback != null) {
            return this.fallback.eval(contextSequence, contextItem);
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (contextSequence != null && !contextSequence.isPersistentSet()) {
            if (this.fallback == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return this.fallback.eval(contextSequence, contextItem);
        }
        if (this.preselectResult == null) {
            long start = System.currentTimeMillis();
            Sequence input = this.getArgument(0).eval(contextSequence);
            if (!(input instanceof VirtualNodeSet) && input.isEmpty()) {
                result = NodeSet.EMPTY_SET;
            } else {
                RangeIndexWorker index = (RangeIndexWorker)this.context.getBroker().getIndexController().getWorkerByIndexId(RangeIndex.ID);
                AtomicValue[] keys = this.getKeys(contextSequence);
                if (keys.length == 0) {
                    return NodeSet.EMPTY_SET;
                }
                ArrayList<QName> qnames = null;
                if (this.contextQName != null) {
                    qnames = new ArrayList<QName>(1);
                    qnames.add(this.contextQName);
                }
                RangeIndex.Operator operator = this.getOperator();
                if (this.usesCollation && !operator.supportsCollation()) {
                    throw new XPathException((Expression)this, RangeIndexModule.EXXQDYFT0001, "Index defines a collation which cannot be used with the '" + (Object)((Object)operator) + "' operation.");
                }
                try {
                    NodeSet inNodes = input.toNodeSet();
                    DocumentSet docs = inNodes.getDocumentSet();
                    result = index.query(this.getExpressionId(), docs, inNodes, qnames, keys, operator, 0);
                }
                catch (IOException e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
            }
            if (this.context.getProfiler().traceFunctions()) {
                this.context.getProfiler().traceIndexUsage(this.context, "new-range", (Expression)this, 1, System.currentTimeMillis() - start);
            }
        } else {
            this.contextStep.setPreloadedData(this.preselectResult.getDocumentSet(), this.preselectResult);
            result = this.getArgument(0).eval(contextSequence).toNodeSet();
        }
        return result;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.fallback != null) {
            this.fallback.resetState(postOptimization);
        }
        if (!postOptimization) {
            this.preselectResult = null;
            this.canOptimize = false;
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        RangeIndexConfigElement rice = this.findConfiguration(contextSequence);
        if (rice == null) {
            this.canOptimize = false;
            if (this.fallback instanceof Optimizable) {
                return ((Optimizable)this.fallback).canOptimize(contextSequence);
            }
            return false;
        }
        this.usesCollation = rice.usesCollation();
        this.canOptimize = true;
        return this.canOptimize;
    }

    private RangeIndexConfigElement findConfiguration(Sequence contextSequence) {
        NodePath path = this.contextPath;
        if (path == null) {
            if (this.contextQName == null) {
                return null;
            }
            path = new NodePath(this.contextQName);
        }
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            RangeIndexConfigElement rice;
            RangeIndexConfig config;
            IndexSpec idxConf;
            Collection collection = (Collection)i.next();
            if (collection.getURI().startsWith(XmldbURI.SYSTEM_COLLECTION_URI) || (idxConf = collection.getIndexConfiguration(this.context.getBroker())) == null || (config = (RangeIndexConfig)idxConf.getCustomIndexSpec(RangeIndex.ID)) == null || (rice = config.find(path)) == null || rice.isComplex()) continue;
            return rice;
        }
        return null;
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public boolean optimizeOnChild() {
        return this.optimizeChild;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public int getDependencies() {
        Expression stringArg = this.getArgument(0);
        if (!Dependency.dependsOn((Expression)stringArg, (int)2)) {
            return 1;
        }
        return 3;
    }

    public int returnsType() {
        return -1;
    }
}

