/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.range;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.indexing.range.RangeIndex;
import org.exist.storage.NodePath;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.Constants;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Pragma;
import org.exist.xquery.Predicate;
import org.exist.xquery.QueryRewriter;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.range.Lookup;
import org.exist.xquery.modules.range.OptimizeFieldPragma;

public class RangeQueryRewriter
extends QueryRewriter {
    public RangeQueryRewriter(XQueryContext context) {
        super(context);
    }

    public Pragma rewriteLocationStep(LocationStep locationStep) throws XPathException {
        Expression parentExpr;
        int axis = locationStep.getAxis();
        if (axis != 5 && axis != 7 && axis != 8 && axis != 6 && axis != 13 && axis != 12) {
            return null;
        }
        if (locationStep.hasPredicates() && (parentExpr = locationStep.getParentExpression()) instanceof RewritableExpression) {
            Predicate pred;
            List preds = locationStep.getPredicates();
            boolean canOptimize = false;
            NodePath contextPath = RangeQueryRewriter.toNodePath(RangeQueryRewriter.getPrecedingSteps(locationStep));
            Iterator iterator = preds.iterator();
            while (iterator.hasNext() && (pred = (Predicate)iterator.next()).getLength() == 1) {
                NodePath path;
                NodePath innerPath;
                Expression innerExpr = pred.getExpression(0);
                List<LocationStep> steps = RangeQueryRewriter.getStepsToOptimize(innerExpr);
                if (steps == null || steps.size() == 0) continue;
                if (innerExpr instanceof InternalFunctionCall) {
                    InternalFunctionCall fcall = (InternalFunctionCall)innerExpr;
                    axis = ((Optimizable)fcall.getFunction()).getOptimizeAxis();
                } else {
                    axis = ((Optimizable)innerExpr).getOptimizeAxis();
                }
                if (axis != 5 && axis != 7 && axis != 8 && axis != 6 && axis != 13 && axis != 12 || (innerPath = RangeQueryRewriter.toNodePath(steps)) == null) continue;
                if (contextPath == null) {
                    path = innerPath;
                } else {
                    path = new NodePath(contextPath);
                    path.append(innerPath);
                }
                if (path.length() <= 0) continue;
                Lookup func = RangeQueryRewriter.rewrite(innerExpr, path);
                func.setFallback(innerExpr, axis);
                func.setLocation(innerExpr.getLine(), innerExpr.getColumn());
                pred.replace(innerExpr, (Expression)new InternalFunctionCall((Function)func));
                canOptimize = true;
            }
            if (canOptimize) {
                return new OptimizeFieldPragma(OptimizeFieldPragma.OPTIMIZE_RANGE_PRAGMA, null, this.getContext());
            }
        }
        return null;
    }

    protected static Lookup rewrite(Expression expression, NodePath path) throws XPathException {
        InternalFunctionCall fcall;
        Function function;
        ArrayList<Expression> eqArgs = new ArrayList<Expression>(2);
        if (expression instanceof GeneralComparison) {
            GeneralComparison comparison = (GeneralComparison)expression;
            eqArgs.add(comparison.getLeft());
            eqArgs.add(comparison.getRight());
            Lookup func = Lookup.create(comparison.getContext(), RangeQueryRewriter.getOperator(expression), path);
            func.setArguments(eqArgs);
            return func;
        }
        if (expression instanceof InternalFunctionCall && (function = (fcall = (InternalFunctionCall)expression).getFunction()) instanceof Lookup && function.isCalledAs("matches")) {
            eqArgs.add(function.getArgument(0));
            eqArgs.add(function.getArgument(1));
            Lookup func = Lookup.create(function.getContext(), RangeIndex.Operator.MATCH, path);
            func.setArguments(eqArgs);
            return func;
        }
        return null;
    }

    protected static List<LocationStep> getStepsToOptimize(Expression expr) {
        InternalFunctionCall fcall;
        Function function;
        if (expr instanceof GeneralComparison) {
            GeneralComparison comparison = (GeneralComparison)expr;
            return BasicExpressionVisitor.findLocationSteps((Expression)comparison.getLeft());
        }
        if (expr instanceof InternalFunctionCall && (function = (fcall = (InternalFunctionCall)expr).getFunction()) instanceof Lookup) {
            if (function.isCalledAs("matches")) {
                return BasicExpressionVisitor.findLocationSteps((Expression)function.getArgument(0));
            }
            Expression original = ((Lookup)function).getFallback();
            return RangeQueryRewriter.getStepsToOptimize(original);
        }
        return null;
    }

    public static RangeIndex.Operator getOperator(Expression expr) {
        InternalFunctionCall fcall;
        Function function;
        if (expr instanceof InternalFunctionCall && (function = (fcall = (InternalFunctionCall)expr).getFunction()) instanceof Lookup) {
            expr = ((Lookup)function).getFallback();
        }
        RangeIndex.Operator operator = RangeIndex.Operator.EQ;
        if (expr instanceof GeneralComparison) {
            GeneralComparison comparison = (GeneralComparison)expr;
            Constants.Comparison relation = comparison.getRelation();
            block0 : switch (relation) {
                case LT: {
                    operator = RangeIndex.Operator.LT;
                    break;
                }
                case GT: {
                    operator = RangeIndex.Operator.GT;
                    break;
                }
                case LTEQ: {
                    operator = RangeIndex.Operator.LE;
                    break;
                }
                case GTEQ: {
                    operator = RangeIndex.Operator.GE;
                    break;
                }
                case EQ: {
                    switch (comparison.getTruncation()) {
                        case BOTH: {
                            operator = RangeIndex.Operator.CONTAINS;
                            break block0;
                        }
                        case LEFT: {
                            operator = RangeIndex.Operator.ENDS_WITH;
                            break block0;
                        }
                        case RIGHT: {
                            operator = RangeIndex.Operator.STARTS_WITH;
                            break block0;
                        }
                    }
                    operator = RangeIndex.Operator.EQ;
                    break;
                }
                case NEQ: {
                    operator = RangeIndex.Operator.NE;
                }
            }
        } else if (expr instanceof InternalFunctionCall) {
            InternalFunctionCall fcall2 = (InternalFunctionCall)expr;
            Function function2 = fcall2.getFunction();
            if (function2 instanceof Lookup && function2.isCalledAs("matches")) {
                operator = RangeIndex.Operator.MATCH;
            }
        } else if (expr instanceof Lookup && ((Function)expr).isCalledAs("matches")) {
            operator = RangeIndex.Operator.MATCH;
        }
        return operator;
    }

    protected static NodePath toNodePath(List<LocationStep> steps) {
        NodePath path = new NodePath();
        for (LocationStep step : steps) {
            if (step == null) {
                return null;
            }
            NodeTest test = step.getTest();
            if (test.isWildcardTest() && step.getAxis() == 12 || test.isWildcardTest() || test.getName() == null) continue;
            int axis = step.getAxis();
            if (axis == 7 || axis == 8) {
                path.addComponent(NodePath.SKIP);
            } else if (axis != 5 && axis != 6) {
                return null;
            }
            path.addComponent(test.getName());
        }
        return path;
    }

    protected static List<LocationStep> getPrecedingSteps(LocationStep current) {
        Expression parentExpr = current.getParentExpression();
        if (!(parentExpr instanceof RewritableExpression)) {
            return null;
        }
        ArrayList<LocationStep> prevSteps = new ArrayList<LocationStep>();
        prevSteps.add(current);
        RewritableExpression parent = (RewritableExpression)parentExpr;
        Expression previous = parent.getPrevious((Expression)current);
        if (previous != null) {
            while (previous != null && previous != parent.getFirst() && previous instanceof LocationStep) {
                LocationStep prevStep = (LocationStep)previous;
                prevSteps.add(0, prevStep);
                previous = parent.getPrevious(previous);
            }
        }
        return prevSteps;
    }
}

