/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.exist.dom.QName;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.ngram.NGramMatch;
import org.exist.numbering.NodeId;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AddMatch
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("add-match", "http://exist-db.org/xquery/ngram", "ngram"), "For each of the nodes in the argument sequence, mark the entire first text descendant as a text match, just as if it had been found through a search operation. At serialization time, the text node will be enclosed in an &lt;exist:match&gt; tag, which facilitates further processing by the kwic module or match highlighting. The function is not directly related to the NGram indexand works without an index; it just uses the NGram module's match processor.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 3, "The node set")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "a node set containing nodes that do not have descendent nodes."));

    public AddMatch(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return args[0];
        }
        NodeValue nv = (NodeValue)args[0].itemAt(0);
        if (!nv.isPersistentSet()) {
            return nv;
        }
        NodeProxy node = (NodeProxy)nv;
        String matchStr = null;
        NodeId nodeId = null;
        try {
            IEmbeddedXMLStreamReader reader = this.context.getBroker().getXMLStreamReader((NodeHandle)node, true);
            while (reader.hasNext()) {
                int status = reader.next();
                if (status != 4) continue;
                matchStr = reader.getText();
                nodeId = (NodeId)reader.getProperty("node-id");
                break;
            }
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOER0000, "Exception caught while reading document");
        }
        catch (XMLStreamException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOER0000, "Exception caught while reading document");
        }
        if (nodeId != null) {
            NGramMatch match = new NGramMatch(this.getContextId(), node.getNodeId(), matchStr);
            match.addOffset(0, matchStr.length());
            node.addMatch((Match)match);
        }
        return node;
    }
}

