/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.ngram.NGramSearch;
import org.exist.xquery.modules.ngram.query.EvaluatableExpression;
import org.exist.xquery.modules.ngram.query.FixedString;
import org.exist.xquery.modules.ngram.query.MergeableExpression;
import org.exist.xquery.modules.ngram.query.WildcardedExpression;

public class AlternativeStrings
implements EvaluatableExpression,
MergeableExpression {
    private final NGramSearch nGramSearch;
    final Set<String> strings;

    public AlternativeStrings(NGramSearch nGramSearch, Set<String> strings) {
        this.nGramSearch = nGramSearch;
        this.strings = strings;
    }

    @Override
    public NodeSet eval(NGramIndexWorker index, DocumentSet docs, List<QName> qnames, NodeSet nodeSet, int axis, int expressionId) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (String s : this.strings) {
            result.addAll(this.nGramSearch.fixedStringSearch(index, docs, qnames, s, nodeSet, axis));
        }
        result.iterate();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AlternativeStrings(");
        for (String str : this.strings) {
            builder.append(", ");
            builder.append(str);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public AlternativeStrings mergeWith(WildcardedExpression otherExpression) {
        HashSet<String> concatenatedStrings = null;
        if (otherExpression instanceof FixedString) {
            FixedString fixedString = (FixedString)otherExpression;
            concatenatedStrings = new HashSet<String>(this.strings.size());
            for (String s : this.strings) {
                concatenatedStrings.add(s + fixedString.fixedString);
            }
        } else {
            AlternativeStrings otherAlternatives = (AlternativeStrings)otherExpression;
            concatenatedStrings = new HashSet(this.strings.size() * otherAlternatives.strings.size());
            for (String s : this.strings) {
                for (String os : otherAlternatives.strings) {
                    concatenatedStrings.add(s + os);
                }
            }
        }
        return new AlternativeStrings(this.nGramSearch, concatenatedStrings);
    }

    @Override
    public boolean mergeableWith(WildcardedExpression otherExpression) {
        return otherExpression instanceof FixedString || otherExpression instanceof AlternativeStrings;
    }
}

