/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.query;

import java.util.HashSet;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.ngram.NGramIndexWorker;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.ngram.NGramSearch;
import org.exist.xquery.modules.ngram.query.AlternativeStrings;
import org.exist.xquery.modules.ngram.query.EvaluatableExpression;
import org.exist.xquery.modules.ngram.query.MergeableExpression;
import org.exist.xquery.modules.ngram.query.WildcardedExpression;

public class FixedString
implements EvaluatableExpression,
MergeableExpression {
    private final NGramSearch nGramSearch;
    final String fixedString;

    public FixedString(NGramSearch nGramSearch, String fixedString) {
        this.nGramSearch = nGramSearch;
        this.fixedString = fixedString;
    }

    @Override
    public NodeSet eval(NGramIndexWorker index, DocumentSet docs, List<QName> qnames, NodeSet nodeSet, int axis, int expressionId) throws XPathException {
        return this.nGramSearch.fixedStringSearch(index, docs, qnames, this.fixedString, nodeSet, axis);
    }

    public String toString() {
        return "FixedString(" + this.fixedString + ")";
    }

    @Override
    public EvaluatableExpression mergeWith(WildcardedExpression otherExpression) {
        if (otherExpression instanceof FixedString) {
            FixedString otherString = (FixedString)otherExpression;
            return new FixedString(this.nGramSearch, this.fixedString + otherString.fixedString);
        }
        AlternativeStrings otherAlternatives = (AlternativeStrings)otherExpression;
        HashSet<String> strings = new HashSet<String>(otherAlternatives.strings.size());
        for (String os : otherAlternatives.strings) {
            strings.add(this.fixedString + os);
        }
        return new AlternativeStrings(this.nGramSearch, strings);
    }

    @Override
    public boolean mergeableWith(WildcardedExpression otherExpression) {
        return otherExpression instanceof FixedString || otherExpression instanceof AlternativeStrings;
    }
}

