/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ngram.utils;

import java.util.function.Function;
import java.util.function.Predicate;
import org.exist.dom.persistent.Match;
import org.exist.dom.persistent.NodeProxy;

public final class NodeProxies {
    private NodeProxies() {
    }

    public static void filterMatches(NodeProxy node, Predicate<Match> predicate) {
        node.setMatches(null);
        for (Match m = node.getMatches(); m != null; m = m.getNextMatch()) {
            if (!predicate.test(m)) continue;
            node.addMatch(m);
        }
    }

    public static NodeProxy transformOwnMatches(NodeProxy node, Function<Match, Match> transform, int ownExpressionId) {
        node.setMatches(null);
        boolean ownMatch = false;
        for (Match m = node.getMatches(); m != null; m = m.getNextMatch()) {
            if (m.getContextId() != ownExpressionId) {
                node.addMatch(m);
                continue;
            }
            Match nm = transform.apply(m);
            if (nm == null) continue;
            node.addMatch(nm);
            ownMatch = true;
        }
        return ownMatch ? node : null;
    }
}

