/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.modules.request;

import org.exist.dom.QName;
import org.exist.extensions.exquery.modules.request.AbstractRequestModuleFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exquery.http.HttpRequest;

public class ConnectionFunctions
extends AbstractRequestModuleFunction {
    private static final QName qnAddress = new QName("address", "http://exquery.org/ns/request", "req");
    private static final QName qnRemoteHostname = new QName("remote-hostname", "http://exquery.org/ns/request", "req");
    private static final QName qnRemoteAddress = new QName("remote-address", "http://exquery.org/ns/request", "req");
    private static final QName qnRemotePort = new QName("remote-port", "http://exquery.org/ns/request", "req");
    public static final FunctionSignature FNS_ADDRESS = new FunctionSignature(qnAddress, "Gets the IP address of the server that received the HTTP Request", null, (SequenceType)new FunctionReturnSequenceType(22, 2, "The IP address of the server."));
    public static final FunctionSignature FNS_REMOTE_HOSTNAME = new FunctionSignature(qnRemoteHostname, "Gets the fully qualified hostname of the client or the last proxy that sent the HTTP Request. If the name of the remote host cannot be established, this method behaves as request:remote-address(), and returns the IP address.", null, (SequenceType)new FunctionReturnSequenceType(22, 2, "The Hostname of the client that issues the HTTP Request."));
    public static final FunctionSignature FNS_REMOTE_ADDRESS = new FunctionSignature(qnRemoteAddress, "Gets the IP address of the client or the last proxy that sent the HTTP Request.", null, (SequenceType)new FunctionReturnSequenceType(31, 2, "The IP address of the client."));
    public static final FunctionSignature FNS_REMOTE_PORT = new FunctionSignature(qnRemotePort, "Gets the TCP port number of the client socket or the last proxy that sent the HTTP Request..", null, (SequenceType)new FunctionReturnSequenceType(31, 2, "The TCP port number of the client."));

    public ConnectionFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, HttpRequest request) throws XPathException {
        StringValue result;
        if (this.isCalledAs(qnAddress.getLocalPart())) {
            result = new StringValue(request.getAddress());
        } else if (this.isCalledAs(qnRemoteHostname.getLocalPart())) {
            result = new StringValue(request.getRemoteHostname());
        } else if (this.isCalledAs(qnRemoteAddress.getLocalPart())) {
            result = new StringValue(request.getRemoteAddress());
        } else if (this.isCalledAs(qnRemotePort.getLocalPart())) {
            result = new IntegerValue((long)request.getRemotePort());
        } else {
            throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        }
        return result;
    }
}

