/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.modules.request;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.extensions.exquery.modules.request.AbstractRequestModuleFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.exquery.http.HttpRequest;

public class HeaderFunctions
extends AbstractRequestModuleFunction {
    private static final QName qnHeaderNames = new QName("header-names", "http://exquery.org/ns/request", "req");
    private static final QName qnHeader = new QName("header", "http://exquery.org/ns/request", "req");
    public static final FunctionSignature FNS_HEADER_NAMES = new FunctionSignature(qnHeaderNames, "Gets the names of HTTP Headers available in the HTTP Request.", null, (SequenceType)new FunctionReturnSequenceType(22, 6, "The names of available HTTP Headers in the HTTP Request."));
    public static final FunctionSignature FNS_HEADER = new FunctionSignature(qnHeader, "Gets the value of the named HTTP Header in the HTTP Request. If there is no such header, then an empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("header-name", 22, 2, "The name of the HTTP Header to retrieve the value of.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "The value of the named HTTP Header, or an empty sequence."));
    public static final FunctionSignature FNS_HEADER_WITH_DEFAULT = new FunctionSignature(qnHeader, "Gets the value of the named HTTP Header in the HTTP Request.  If there is no such header in the HTTP Request, then the value specified in $default is returned instead.", new SequenceType[]{new FunctionParameterSequenceType("header-name", 22, 2, "The name of the HTTP Header to retrieve the value of."), new FunctionParameterSequenceType("default", 22, 2, "The default value to use if the named HTTP Header is not present in the request.")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "The value of the named HTTP Header, or the default value."));

    public HeaderFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, HttpRequest request) throws XPathException {
        if (this.isCalledAs(qnHeaderNames.getLocalPart())) {
            ValueSequence result = new ValueSequence();
            Iterator iterator = request.getHeaderNames().iterator();
            while (iterator.hasNext()) {
                String parameterName = (String)iterator.next();
                result.add((Item)new StringValue(parameterName));
            }
            return result;
        }
        if (!this.isCalledAs(qnHeader.getLocalPart())) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        String headerName = args[0].getStringValue();
        if (this.getSignature().getArgumentCount() == 1) {
            return this.getHeader(request, headerName, null);
        }
        if (this.getSignature().getArgumentCount() != 2) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        Sequence defaultValues = args[1];
        return this.getHeader(request, headerName, defaultValues);
    }

    private Sequence getHeader(HttpRequest request, String headerName, Sequence defaultValues) throws XPathException {
        String headerValue = request.getHeader(headerName);
        Object result = headerValue == null ? (defaultValues != null ? defaultValues : Sequence.EMPTY_SEQUENCE) : new StringValue(headerValue);
        return result;
    }
}

