/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.modules.request;

import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.extensions.exquery.modules.request.AbstractRequestModuleFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.exquery.http.HttpRequest;

public class ParameterFunctions
extends AbstractRequestModuleFunction {
    private static final QName qnParameterNames = new QName("parameter-names", "http://exquery.org/ns/request", "req");
    private static final QName qnParameter = new QName("parameter", "http://exquery.org/ns/request", "req");
    public static final FunctionSignature FNS_PARAMETER_NAMES = new FunctionSignature(qnParameterNames, "Gets the names of parameters available in the HTTP Request.", null, (SequenceType)new FunctionReturnSequenceType(22, 7, "The names of available parameters from the HTTP Request."));
    public static final FunctionSignature FNS_PARAMETER = new FunctionSignature(qnParameter, "Gets the values of the named parameter from the HTTP Request. If there is no such parameter in the HTTP Request, then an empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("parameter-name", 22, 2, "The name of the parameter to retrieve values of.")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "The value(s) of the named parameter, or an empty sequence."));
    public static final FunctionSignature FNS_PARAMETER_WITH_DEFAULT = new FunctionSignature(qnParameter, "Gets the values of the named parameter from the HTTP Request. If there is no such parameter in the HTTP Request, then the value specified in $default is returned instead.", new SequenceType[]{new FunctionParameterSequenceType("parameter-name", 22, 2, "The name of the parameter to retrieve values of."), new FunctionParameterSequenceType("default", 22, 7, "The default value(s) to use if the named parameter is not present in the request.")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "The value(s) of the named parameter, or the default value(s)."));

    public ParameterFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, HttpRequest request) throws XPathException {
        if (this.isCalledAs(qnParameterNames.getLocalPart())) {
            ValueSequence result = new ValueSequence();
            Iterator iterator = request.getParameterNames().iterator();
            while (iterator.hasNext()) {
                String parameterName = (String)iterator.next();
                result.add((Item)new StringValue(parameterName));
            }
            return result;
        }
        if (!this.isCalledAs(qnParameter.getLocalPart())) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        String paramName = args[0].getStringValue();
        if (this.getSignature().getArgumentCount() == 1) {
            return this.getParameter(request, paramName, null);
        }
        if (this.getSignature().getArgumentCount() != 2) throw new XPathException((Expression)this, "Unknown function call: " + this.getSignature());
        Sequence defaultValues = args[1];
        return this.getParameter(request, paramName, defaultValues);
    }

    private Sequence getParameter(HttpRequest request, String paramName, Sequence defaultValues) throws XPathException {
        Sequence result;
        Object queryParamValues = request.getQueryParam(paramName);
        if (queryParamValues == null) {
            result = defaultValues != null ? defaultValues : Sequence.EMPTY_SEQUENCE;
        } else {
            result = new ValueSequence();
            if (queryParamValues instanceof List) {
                for (Object value : (List)queryParamValues) {
                    result.add((Item)new StringValue(value.toString()));
                }
            } else {
                result.add((Item)new StringValue(queryParamValues.toString()));
            }
        }
        return result;
    }
}

