/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockNullResource;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockingCollectionResource;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.webdav.ExistCollection;
import org.exist.webdav.ExistResource;
import org.exist.webdav.MiltonDocument;
import org.exist.webdav.MiltonResource;
import org.exist.webdav.exceptions.CollectionDoesNotExistException;
import org.exist.webdav.exceptions.CollectionExistsException;
import org.exist.xmldb.XmldbURI;

public class MiltonCollection
extends MiltonResource
implements CollectionResource,
GetableResource,
PropFindableResource,
DeletableResource,
MakeCollectionableResource,
PutableResource,
LockingCollectionResource,
MoveableResource,
CopyableResource,
LockNullResource {
    private ExistCollection existCollection;

    public MiltonCollection(String host, XmldbURI uri, BrokerPool pool) {
        this(host, uri, pool, null);
    }

    public MiltonCollection(String host, XmldbURI uri, BrokerPool pool, Subject subject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("COLLECTION=%s", uri.toString()));
        }
        this.resourceXmldbUri = uri;
        this.brokerPool = pool;
        this.host = host;
        this.existCollection = new ExistCollection(uri, this.brokerPool);
        this.existResource = this.existCollection;
        if (subject != null) {
            this.existCollection.setUser(subject);
            this.existCollection.initMetadata();
        }
    }

    public Resource child(String childName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("get child=%s", childName));
        }
        if (childName == null) {
            return null;
        }
        List<? extends Resource> allResources = this.getChildren();
        for (Resource resource : allResources) {
            if (!childName.equals(resource.getName())) continue;
            return resource;
        }
        return null;
    }

    private List<MiltonCollection> getCollectionResources() {
        ArrayList<MiltonCollection> allResources = new ArrayList<MiltonCollection>();
        for (XmldbURI path : this.existCollection.getCollectionURIs()) {
            allResources.add(new MiltonCollection(this.host, path, this.brokerPool, this.subject));
        }
        return allResources;
    }

    private List<MiltonDocument> getDocumentResources() {
        ArrayList<MiltonDocument> allResources = new ArrayList<MiltonDocument>();
        for (XmldbURI path : this.existCollection.getDocumentURIs()) {
            MiltonDocument mdoc = new MiltonDocument(this.host, path, this.brokerPool, this.subject);
            mdoc.setIsPropFind(true);
            allResources.add(mdoc);
        }
        return allResources;
    }

    public List<? extends Resource> getChildren() {
        ArrayList<MiltonResource> allResources = new ArrayList<MiltonResource>();
        allResources.addAll(this.getCollectionResources());
        allResources.addAll(this.getDocumentResources());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Nr of children=%s", allResources.size()));
        }
        return allResources;
    }

    public Date getCreateDate() {
        Date createDate = null;
        Long time = this.existCollection.getCreationTime();
        if (time != null) {
            createDate = new Date(time);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Create date=%s", createDate));
        }
        return createDate;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Delete collection '%s'.", this.resourceXmldbUri));
        }
        this.existCollection.delete();
    }

    public CollectionResource createCollection(String name) throws NotAuthorizedException, ConflictException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Create collection '%s' in '%s'.", name, this.resourceXmldbUri));
        }
        MiltonCollection collection = null;
        try {
            XmldbURI collectionURI = this.existCollection.createCollection(name);
            collection = new MiltonCollection(this.host, collectionURI, this.brokerPool, this.subject);
        }
        catch (PermissionDeniedException ex) {
            LOG.debug(ex.getMessage());
            throw new NotAuthorizedException((Resource)this);
        }
        catch (EXistException | CollectionExistsException ex) {
            LOG.debug(ex.getMessage());
            throw new ConflictException((Resource)this);
        }
        return collection;
    }

    public Resource createNew(String newName, InputStream is, Long length, String contentType) throws IOException, ConflictException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Create '%s' in '%s'", newName, this.resourceXmldbUri));
        }
        MiltonDocument resource = null;
        try {
            XmldbURI resourceURI = this.existCollection.createFile(newName, is, length, contentType);
            resource = new MiltonDocument(this.host, resourceURI, this.brokerPool, this.subject);
        }
        catch (IOException | PermissionDeniedException | CollectionDoesNotExistException e) {
            LOG.debug(e.getMessage());
            throw new ConflictException((Resource)this);
        }
        return resource;
    }

    public LockToken createAndLock(String name, LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("'%s' name='%s'", this.resourceXmldbUri, name));
        }
        String token = UUID.randomUUID().toString();
        return new LockToken(token, lockInfo, timeout);
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("'%s' -- %s", this.resourceXmldbUri, lockInfo.toString()));
        }
        return this.refreshLock(UUID.randomUUID().toString());
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("'%s' token='%s'", this.resourceXmldbUri, token));
        }
        LockInfo lockInfo = new LockInfo(LockInfo.LockScope.NONE, LockInfo.LockType.READ, token, LockInfo.LockDepth.ZERO);
        LockTimeout lockTime = new LockTimeout(Long.valueOf(Long.MAX_VALUE));
        LockToken lockToken = new LockToken(token, lockInfo, lockTime);
        return new LockResult(LockResult.FailureReason.PRECONDITION_FAILED, lockToken);
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("'%s' token='%s'", this.resourceXmldbUri, tokenId));
        }
    }

    public LockToken getCurrentLock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("'%s'", this.resourceXmldbUri));
        }
        return null;
    }

    public void moveTo(CollectionResource rDest, String newName) throws ConflictException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Move '%s' to '%s' in '%s'", this.resourceXmldbUri, newName, rDest.getName()));
        }
        XmldbURI destCollection = ((MiltonCollection)rDest).getXmldbUri();
        try {
            this.existCollection.resourceCopyMove(destCollection, newName, ExistResource.Mode.MOVE);
        }
        catch (EXistException ex) {
            throw new ConflictException((Resource)this);
        }
    }

    public void copyTo(CollectionResource toCollection, String newName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Move '%s' to '%s' in '%s'", this.resourceXmldbUri, newName, toCollection.getName()));
        }
        XmldbURI destCollection = ((MiltonCollection)toCollection).getXmldbUri();
        try {
            this.existCollection.resourceCopyMove(destCollection, newName, ExistResource.Mode.COPY);
        }
        catch (EXistException ex) {
            LOG.error(ex.getMessage());
        }
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        try {
            XMLOutputFactory xf = XMLOutputFactory.newInstance();
            xf.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter writer = xf.createXMLStreamWriter(out);
            writer.setDefaultNamespace("http://exist.sourceforge.net/NS/exist");
            writer.writeStartDocument();
            writer.writeComment("Warning: this XML format is *not* part of the WebDAV specification.");
            writer.writeStartElement("exist", "result", "http://exist.sourceforge.net/NS/exist");
            writer.writeStartElement("exist", "collection", "http://exist.sourceforge.net/NS/exist");
            writer.writeAttribute("name", this.resourceXmldbUri.lastSegment().toString());
            writer.writeAttribute("created", this.getXmlDateTime(this.existCollection.getCreationTime()));
            writer.writeAttribute("owner", this.existCollection.getOwnerUser());
            writer.writeAttribute("group", this.existCollection.getOwnerGroup());
            writer.writeAttribute("permissions", "" + this.existCollection.getPermissions().toString());
            for (MiltonCollection collection : this.getCollectionResources()) {
                collection.writeXML(writer);
            }
            for (MiltonDocument document : this.getDocumentResources()) {
                document.writeXML(writer);
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            LOG.error((Object)ex);
            throw new IOException(ex.getMessage());
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return "application/xml";
    }

    public Long getContentLength() {
        return null;
    }

    private void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("exist", "collection", "http://exist.sourceforge.net/NS/exist");
        writer.writeAttribute("name", this.resourceXmldbUri.lastSegment().toString());
        writer.writeAttribute("created", this.getXmlDateTime(this.existCollection.getCreationTime()));
        writer.writeAttribute("owner", this.existCollection.getOwnerUser());
        writer.writeAttribute("group", this.existCollection.getOwnerGroup());
        writer.writeAttribute("permissions", this.existCollection.getPermissions().toString());
        writer.writeEndElement();
    }
}

