/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import com.bradmcevoy.http.webdav.DefaultUserAgentHelper;
import com.bradmcevoy.http.webdav.UserAgentHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.util.VirtualTempFile;
import org.exist.webdav.ByteCountOutputStream;
import org.exist.webdav.ExistDocument;
import org.exist.webdav.ExistResource;
import org.exist.webdav.MiltonCollection;
import org.exist.webdav.MiltonResource;
import org.exist.webdav.exceptions.DocumentAlreadyLockedException;
import org.exist.webdav.exceptions.DocumentNotLockedException;
import org.exist.xmldb.XmldbURI;

public class MiltonDocument
extends MiltonResource
implements GetableResource,
PropFindableResource,
DeletableResource,
LockableResource,
MoveableResource,
CopyableResource {
    public static final String PROPFIND_METHOD_XML_SIZE = "org.exist.webdav.PROPFIND_METHOD_XML_SIZE";
    public static final String GET_METHOD_XML_SIZE = "org.exist.webdav.GET_METHOD_XML_SIZE";
    private static SIZE_METHOD propfindSizeMethod = null;
    private static SIZE_METHOD getSizeMethod = null;
    private static UserAgentHelper userAgentHelper = null;
    private ExistDocument existDocument;
    private VirtualTempFile vtf = null;
    private boolean isPropFind = false;

    public MiltonDocument(String host, XmldbURI uri, BrokerPool brokerPool) {
        this(host, uri, brokerPool, null);
    }

    public MiltonDocument(String host, XmldbURI uri, BrokerPool pool, Subject subject) {
        String systemProp;
        if (userAgentHelper == null) {
            userAgentHelper = new DefaultUserAgentHelper();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("DOCUMENT:%s", uri.toString()));
        }
        this.resourceXmldbUri = uri;
        this.brokerPool = pool;
        this.host = host;
        this.existDocument = new ExistDocument(uri, this.brokerPool);
        this.existResource = this.existDocument;
        if (subject != null) {
            this.existDocument.setUser(subject);
            this.existDocument.initMetadata();
        }
        if (propfindSizeMethod == null) {
            systemProp = System.getProperty(PROPFIND_METHOD_XML_SIZE);
            if (systemProp == null) {
                propfindSizeMethod = SIZE_METHOD.APPROXIMATE;
            } else {
                try {
                    propfindSizeMethod = SIZE_METHOD.valueOf(systemProp.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    LOG.debug(ex.getMessage());
                    propfindSizeMethod = SIZE_METHOD.APPROXIMATE;
                }
            }
        }
        if (getSizeMethod == null) {
            systemProp = System.getProperty(GET_METHOD_XML_SIZE);
            if (systemProp == null) {
                getSizeMethod = SIZE_METHOD.NULL;
            } else {
                try {
                    getSizeMethod = SIZE_METHOD.valueOf(systemProp.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    LOG.debug(ex.getMessage());
                    getSizeMethod = SIZE_METHOD.APPROXIMATE;
                }
            }
        }
    }

    public void setIsPropFind(boolean isPropFind) {
        this.isPropFind = isPropFind;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        try {
            if (this.vtf == null) {
                LOG.debug("Serializing from database");
                this.existDocument.stream(out);
            } else {
                LOG.debug("Serializing from buffer");
                InputStream is = this.vtf.getByteStream();
                IOUtils.copy((InputStream)is, (OutputStream)out);
                out.flush();
                IOUtils.closeQuietly((InputStream)is);
                this.vtf.delete();
                this.vtf = null;
            }
        }
        catch (PermissionDeniedException e) {
            LOG.debug(e.getMessage());
            throw new NotAuthorizedException((Resource)this);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return this.existDocument.getMimeType();
    }

    public Long getContentLength() {
        Long size = null;
        boolean isMacFinder = userAgentHelper.isMacFinder(HttpManager.request().getUserAgentHeader());
        if (this.existDocument.isXmlDocument()) {
            if (this.isPropFind) {
                if (isMacFinder || SIZE_METHOD.EXACT == propfindSizeMethod) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Serializing XML to /dev/null to determine size (%s) MacFinder=%s", this.resourceXmldbUri, isMacFinder));
                    }
                    ByteCountOutputStream counter = new ByteCountOutputStream();
                    try {
                        this.existDocument.stream(counter);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                    }
                    size = counter.getByteCount();
                } else {
                    size = SIZE_METHOD.NULL == propfindSizeMethod ? null : Long.valueOf(this.existDocument.getContentLength());
                }
            } else if (SIZE_METHOD.EXACT == getSizeMethod) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Serializing XML to virtual file (%s)", this.resourceXmldbUri));
                    }
                    this.vtf = new VirtualTempFile();
                    this.existDocument.stream((OutputStream)this.vtf);
                    this.vtf.close();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
                size = this.vtf.length();
            } else if (SIZE_METHOD.APPROXIMATE == getSizeMethod) {
                size = this.existDocument.getContentLength();
                this.vtf = null;
            } else {
                size = null;
                this.vtf = null;
            }
        } else {
            size = this.existDocument.getContentLength();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Size=%s (%s)", size, this.resourceXmldbUri));
        }
        return size;
    }

    public Date getCreateDate() {
        Date createDate = null;
        Long time = this.existDocument.getCreationTime();
        if (time != null) {
            createDate = new Date(time);
        }
        return createDate;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        this.existDocument.delete();
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        org.exist.dom.persistent.LockToken inputToken = this.convertToken(timeout, lockInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Lock: %s", this.resourceXmldbUri));
        }
        LockResult lr = null;
        try {
            org.exist.dom.persistent.LockToken existLT = this.existDocument.lock(inputToken);
            LockToken mltonLT = this.convertToken(existLT);
            lr = LockResult.success((LockToken)mltonLT);
        }
        catch (PermissionDeniedException ex) {
            LOG.debug(ex.getMessage());
            throw new NotAuthorizedException((Resource)this);
        }
        catch (DocumentAlreadyLockedException ex) {
            LOG.debug(ex.getMessage());
            lr = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
        catch (EXistException ex) {
            LOG.debug(ex.getMessage());
            lr = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.PRECONDITION_FAILED);
        }
        return lr;
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Refresh: %s token=%s", this.resourceXmldbUri, token));
        }
        LockResult lr = null;
        try {
            org.exist.dom.persistent.LockToken existLT = this.existDocument.refreshLock(token);
            LockToken mltonLT = this.convertToken(existLT);
            lr = LockResult.success((LockToken)mltonLT);
        }
        catch (PermissionDeniedException ex) {
            LOG.debug(ex.getMessage());
            throw new NotAuthorizedException((Resource)this);
        }
        catch (EXistException | DocumentNotLockedException ex) {
            LOG.debug(ex.getMessage());
            lr = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.PRECONDITION_FAILED);
        }
        catch (DocumentAlreadyLockedException ex) {
            LOG.debug(ex.getMessage());
            lr = LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
        return lr;
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Unlock: %s", this.resourceXmldbUri));
        }
        try {
            this.existDocument.unlock();
        }
        catch (PermissionDeniedException ex) {
            LOG.debug(ex.getMessage());
            throw new NotAuthorizedException((Resource)this);
        }
        catch (EXistException | DocumentNotLockedException ex) {
            LOG.debug(ex.getMessage());
            throw new PreConditionFailedException((Resource)this);
        }
    }

    public LockToken getCurrentLock() {
        org.exist.dom.persistent.LockToken existLT;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("getCurrentLock: %s", this.resourceXmldbUri));
        }
        if ((existLT = this.existDocument.getCurrentLock()) == null) {
            LOG.debug("No database lock token.");
            return null;
        }
        LockToken miltonLT = this.convertToken(existLT);
        return miltonLT;
    }

    public void moveTo(CollectionResource rDest, String newName) throws ConflictException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("moveTo: %s newName=%s", this.resourceXmldbUri, newName));
        }
        XmldbURI destCollection = ((MiltonCollection)rDest).getXmldbUri();
        try {
            this.existDocument.resourceCopyMove(destCollection, newName, ExistResource.Mode.MOVE);
        }
        catch (EXistException ex) {
            throw new ConflictException((Resource)this);
        }
    }

    public void copyTo(CollectionResource rDest, String newName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("copyTo: %s newName=%s", this.resourceXmldbUri, newName));
        }
        XmldbURI destCollection = ((MiltonCollection)rDest).getXmldbUri();
        try {
            this.existDocument.resourceCopyMove(destCollection, newName, ExistResource.Mode.COPY);
        }
        catch (EXistException ex) {
            LOG.error(ex.getMessage());
        }
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("exist", "document", "http://exist.sourceforge.net/NS/exist");
        writer.writeAttribute("name", this.resourceXmldbUri.lastSegment().toString());
        writer.writeAttribute("created", this.getXmlDateTime(this.existDocument.getCreationTime()));
        writer.writeAttribute("last-modified", this.getXmlDateTime(this.existDocument.getLastModified()));
        writer.writeAttribute("owner", this.existDocument.getOwnerUser());
        writer.writeAttribute("group", this.existDocument.getOwnerGroup());
        writer.writeAttribute("permissions", "" + this.existDocument.getPermissions().toString());
        writer.writeAttribute("size", "" + this.existDocument.getContentLength());
        writer.writeEndElement();
    }

    public void setSerializationConfiguration(Properties config) {
        this.existDocument.setSerializationConfiguration(config);
    }

    private static enum SIZE_METHOD {
        NULL,
        EXACT,
        APPROXIMATE;

    }
}

