/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class BackupDialog
extends JDialog {
    private static final long serialVersionUID = -4960002499478536048L;
    JTextField currentCollection;
    JTextField currentFile;
    JProgressBar progress;

    public BackupDialog() throws HeadlessException {
        this.setupComponents();
    }

    public BackupDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, "Backup", modal);
        this.setupComponents();
        this.pack();
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel("Collection:");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentCollection = new JTextField(40);
        this.currentCollection.setEditable(false);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.currentCollection, c);
        this.getContentPane().add(this.currentCollection);
        label = new JLabel("Storing file:");
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentFile = new JTextField(40);
        this.currentFile.setEditable(false);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.currentFile, c);
        this.getContentPane().add(this.currentFile);
        label = new JLabel("Collection Progress:");
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(false);
        this.progress.setStringPainted(true);
        this.progress.setMinimumSize(new Dimension(200, 30));
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.progress, c);
        this.getContentPane().add(this.progress);
    }

    public void setCollection(String collection) {
        this.currentCollection.setText(collection);
    }

    public void setResource(String resource) {
        this.currentFile.setText(resource);
    }

    public void setResourceCount(int count) {
        this.progress.setMaximum(count);
    }

    public void setProgress(int count) {
        this.progress.setValue(count);
    }
}

