/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BackupFile {
    private File file;
    private Date date;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmm");

    public BackupFile(File file, String dateTime) {
        this.file = file;
        try {
            this.date = this.dateFormat.parse(dateTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean after(BackupFile other) {
        return this.date.after(other.date);
    }

    public boolean after(long time) {
        return this.date.getTime() > time;
    }

    public boolean before(BackupFile other) {
        return this.date.before(other.date);
    }

    public boolean before(long time) {
        return time > this.date.getTime();
    }

    public File getFile() {
        return this.file;
    }

    public Date getDate() {
        return this.date;
    }
}

