/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.exist.backup.ErrorReport;
import org.exist.collections.Collection;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.numbering.NodeId;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.AccountImpl;
import org.exist.stax.AbstractEmbeddedXMLStreamReader;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.DOMTransaction;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;

public class ConsistencyCheck {
    private Stack<ElementNode> elementStack = new Stack();
    private int documentCount = -1;
    private DBBroker broker;
    private int defaultIndexDepth;
    private boolean directAccess = false;
    private boolean checkDocs = false;

    public ConsistencyCheck(DBBroker broker, boolean directAccess, boolean checkDocs) {
        this.broker = broker;
        this.defaultIndexDepth = ((NativeBroker)broker).getDefaultIndexDepth();
        this.directAccess = directAccess;
        this.checkDocs = checkDocs;
    }

    public List<ErrorReport> checkAll(ProgressCallback callback) throws TerminatedException, PermissionDeniedException {
        List<ErrorReport> errors = this.checkCollectionTree(callback);
        this.checkDocuments(callback, errors);
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ErrorReport> checkCollectionTree(ProgressCallback callback) throws TerminatedException, PermissionDeniedException {
        AccountImpl.getSecurityProperties().enableCheckPasswords(false);
        try {
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
            Collection root = this.broker.getCollection(XmldbURI.ROOT_COLLECTION_URI);
            this.checkCollection(root, errors, callback);
            ArrayList<ErrorReport> arrayList = errors;
            return arrayList;
        }
        finally {
            AccountImpl.getSecurityProperties().enableCheckPasswords(true);
        }
    }

    private void checkCollection(Collection collection, List<ErrorReport> errors, ProgressCallback callback) throws TerminatedException {
        block7: {
            XmldbURI uri = collection.getURI();
            if (callback != null) {
                callback.startCollection(uri.toString());
            }
            this.checkPermissions(collection, errors);
            try {
                Iterator<XmldbURI> i = collection.collectionIteratorNoLock(this.broker);
                while (i.hasNext()) {
                    ErrorReport.CollectionError error;
                    XmldbURI childUri = i.next();
                    try {
                        Collection child = this.broker.getCollection(uri.append(childUri));
                        if (child == null) {
                            error = new ErrorReport.CollectionError(4, "Child collection not found: " + childUri + ", parent is " + uri);
                            error.setCollectionId(collection.getId());
                            error.setCollectionURI(childUri);
                            errors.add(error);
                            if (callback == null) continue;
                            callback.error(error);
                            continue;
                        }
                        if (child.getId() == collection.getId()) continue;
                        this.checkCollection(child, errors, callback);
                    }
                    catch (Exception e) {
                        error = new ErrorReport.CollectionError(4, "Error while loading child collection: " + childUri + ", parent is " + uri);
                        error.setCollectionId(collection.getId());
                        error.setCollectionURI(childUri);
                        errors.add(error);
                        if (callback == null) continue;
                        callback.error(error);
                    }
                }
            }
            catch (PermissionDeniedException pde) {
                ErrorReport.CollectionError error = new ErrorReport.CollectionError(4, "Error while loading collection: " + collection.getURI() + ", parent is " + uri);
                error.setCollectionId(collection.getId());
                error.setCollectionURI(collection.getURI());
                errors.add(error);
                if (callback == null) break block7;
                callback.error(error);
            }
        }
    }

    public int getDocumentCount() throws TerminatedException {
        if (this.documentCount == -1) {
            AccountImpl.getSecurityProperties().enableCheckPasswords(false);
            try {
                DocumentCallback cb = new DocumentCallback(null, null, false);
                this.broker.getResourcesFailsafe(cb, this.directAccess);
                this.documentCount = cb.docCount;
            }
            finally {
                AccountImpl.getSecurityProperties().enableCheckPasswords(true);
            }
        }
        return this.documentCount;
    }

    public List<ErrorReport> checkDocuments(ProgressCallback progress) throws TerminatedException {
        ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>();
        this.checkDocuments(progress, errors);
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDocuments(ProgressCallback progress, List<ErrorReport> errorList) throws TerminatedException {
        AccountImpl.getSecurityProperties().enableCheckPasswords(false);
        try {
            DocumentCallback cb = new DocumentCallback(errorList, progress, true);
            this.broker.getResourcesFailsafe(cb, this.directAccess);
            cb.checkDocs();
        }
        finally {
            AccountImpl.getSecurityProperties().enableCheckPasswords(true);
        }
    }

    public void checkPermissions(Collection collection, List<ErrorReport> errorList) {
        try {
            Group group;
            Permission perms = collection.getPermissions();
            Account owner = perms.getOwner();
            if (owner == null) {
                ErrorReport.CollectionError error = new ErrorReport.CollectionError(3, "Owner account not found for collection: " + collection.getURI());
                error.setCollectionId(collection.getId());
                error.setCollectionURI(collection.getURI());
                errorList.add(error);
            }
            if ((group = perms.getGroup()) == null) {
                ErrorReport.CollectionError error = new ErrorReport.CollectionError(3, "Owner group not found for collection: " + collection.getURI());
                error.setCollectionId(collection.getId());
                error.setCollectionURI(collection.getURI());
                errorList.add(error);
            }
        }
        catch (Exception e) {
            ErrorReport.CollectionError error = new ErrorReport.CollectionError(3, "Exception caught while : " + collection.getURI());
            error.setCollectionId(collection.getId());
            error.setCollectionURI(collection.getURI());
            errorList.add(error);
        }
    }

    public ErrorReport checkPermissions(DocumentImpl doc) {
        try {
            Permission perms = doc.getPermissions();
            Account owner = perms.getOwner();
            if (owner == null) {
                return new ErrorReport.ResourceError(5, "Owner account not found for document " + doc.getFileURI());
            }
            Group group = perms.getGroup();
            if (group == null) {
                return new ErrorReport.ResourceError(5, "Owner group not found for document " + doc.getFileURI());
            }
        }
        catch (Exception e) {
            return new ErrorReport.ResourceError(5, "Exception caught while checking permissions on document " + doc.getFileURI(), e);
        }
        return null;
    }

    public ErrorReport checkDocument(final DocumentImpl doc) {
        DOMFile domDb = ((NativeBroker)this.broker).getDOMFile();
        return (ErrorReport)new DOMTransaction(this, domDb, Lock.LockMode.WRITE_LOCK, doc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object start() {
                AbstractEmbeddedXMLStreamReader reader = null;
                try {
                    ElementImpl root = (ElementImpl)doc.getDocumentElement();
                    if (root == null) {
                        ErrorReport.ResourceError resourceError = new ErrorReport.ResourceError(5, "Failed to access document data");
                        return resourceError;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ErrorReport.ResourceError resourceError = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    return resourceError;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }
        }.run();
    }

    public ErrorReport checkXMLTree(final DocumentImpl doc) {
        final DOMFile domDb = ((NativeBroker)this.broker).getDOMFile();
        return (ErrorReport)new DOMTransaction(this, domDb, Lock.LockMode.WRITE_LOCK, doc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object start() {
                ErrorReport.ResourceError resourceError;
                AbstractEmbeddedXMLStreamReader reader = null;
                try {
                    ElementImpl root = (ElementImpl)doc.getDocumentElement();
                    reader = (EmbeddedXMLStreamReader)ConsistencyCheck.this.broker.getXMLStreamReader(root, true);
                    boolean attribsAllowed = false;
                    int expectedAttribs = 0;
                    int attributeCount = 0;
                    block49: while (reader.hasNext()) {
                        ErrorReport.ResourceError resourceError2;
                        int status = reader.next();
                        NodeId nodeId = (NodeId)reader.getProperty("node-id");
                        ElementNode parent = null;
                        if (status != 2 && !ConsistencyCheck.this.elementStack.isEmpty()) {
                            parent = (ElementNode)ConsistencyCheck.this.elementStack.peek();
                            ++parent.childCount;
                            if (!nodeId.isChildOf(parent.elem.getNodeId())) {
                                resourceError2 = new ErrorReport.ResourceError(2, "Node " + nodeId + " is not a child of " + parent.elem.getNodeId());
                                return resourceError2;
                            }
                            if (!(parent.prevSibling == null || nodeId.isSiblingOf(parent.prevSibling) && nodeId.compareTo(parent.prevSibling) > 0)) {
                                resourceError2 = new ErrorReport.ResourceError(0, "Node " + nodeId + " is not a sibling of " + parent.prevSibling);
                                return resourceError2;
                            }
                            parent.prevSibling = nodeId;
                        }
                        switch (status) {
                            case 10: {
                                ++attributeCount;
                                continue block49;
                            }
                            case 2: {
                                if (ConsistencyCheck.this.elementStack.isEmpty()) {
                                    resourceError2 = new ErrorReport.ResourceError(2, "Error in node hierarchy: received END_ELEMENT event but stack was empty!");
                                    return resourceError2;
                                }
                                ElementNode lastElem = (ElementNode)ConsistencyCheck.this.elementStack.pop();
                                if (lastElem.childCount == lastElem.elem.getChildCount()) continue block49;
                                ErrorReport.ResourceError e = new ErrorReport.ResourceError(2, "Element reports incorrect child count: expected " + lastElem.elem.getChildCount() + " but found " + lastElem.childCount);
                                return e;
                            }
                            case 1: {
                                IStoredNode node;
                                if (nodeId.getTreeLevel() <= ConsistencyCheck.this.defaultIndexDepth) {
                                    NativeBroker.NodeRef nodeRef = new NativeBroker.NodeRef(doc.getDocId(), nodeId);
                                    try {
                                        Value v;
                                        long p = domDb.findValue(nodeRef);
                                        if (p != ((EmbeddedXMLStreamReader)reader).getCurrentPosition() && (v = domDb.get(p)) == null) {
                                            ErrorReport.IndexError indexError = new ErrorReport.IndexError(6, "Failed to access node " + nodeId + " through dom.dbx index. Wrong storage address. Expected: " + p + "; got: " + ((EmbeddedXMLStreamReader)reader).getCurrentPosition() + " - ", doc.getDocId());
                                            return indexError;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        ErrorReport.IndexError e2 = new ErrorReport.IndexError(6, "Failed to access node " + nodeId + " through dom.dbx index.", e, doc.getDocId());
                                        return e2;
                                    }
                                }
                                if ((node = reader.getNode()).getNodeType() != 1) {
                                    ErrorReport.ResourceError e = new ErrorReport.ResourceError(1, "Expected an element node, received node of type " + node.getNodeType());
                                    return e;
                                }
                                ConsistencyCheck.this.elementStack.push(new ElementNode((ElementImpl)node));
                                attribsAllowed = true;
                                attributeCount = 0;
                                expectedAttribs = reader.getAttributeCount();
                                continue block49;
                            }
                        }
                        if (attribsAllowed && attributeCount != expectedAttribs) {
                            resourceError2 = new ErrorReport.ResourceError(1, "Wrong number of attributes. Expected: " + expectedAttribs + "; found: " + attributeCount);
                            return resourceError2;
                        }
                        attribsAllowed = false;
                    }
                    if (!ConsistencyCheck.this.elementStack.isEmpty()) {
                        ErrorReport.ResourceError resourceError3 = new ErrorReport.ResourceError(2, "Error in node hierarchy: reached end of tree but stack was not empty!");
                        return resourceError3;
                    }
                    Object var7_13 = null;
                    return var7_13;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    resourceError = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    return resourceError;
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                    resourceError = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    return resourceError;
                }
                finally {
                    ConsistencyCheck.this.elementStack.clear();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.run();
    }

    private class DocumentCallback
    implements BTreeCallback {
        private List<ErrorReport> errors;
        private ProgressCallback progress;
        private int docCount = 0;
        private boolean checkDocs;
        private int lastPercentage = -1;
        private Agent jmxAgent = AgentFactory.getInstance();
        private ArrayList<DocumentImpl> docs = new ArrayList(8192);

        private DocumentCallback(List<ErrorReport> errors, ProgressCallback progress, boolean checkDocs) {
            this.errors = errors;
            this.progress = progress;
            this.checkDocs = checkDocs;
        }

        @Override
        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            block8: {
                CollectionStore store = (CollectionStore)((NativeBroker)ConsistencyCheck.this.broker).getStorage((byte)0);
                int docId = CollectionStore.DocumentKey.getDocumentId(key);
                try {
                    byte type = key.data()[key.start() + 4 + 1];
                    VariableByteInput istream = store.getAsStream(pointer);
                    DocumentImpl doc = null;
                    doc = type == 1 ? new BinaryDocument(ConsistencyCheck.this.broker.getBrokerPool()) : new DocumentImpl(ConsistencyCheck.this.broker.getBrokerPool());
                    doc.read(istream);
                    ++this.docCount;
                    if (this.checkDocs) {
                        if (this.progress != null) {
                            this.progress.startDocument(doc.getFileURI().toString(), this.docCount, ConsistencyCheck.this.getDocumentCount());
                        }
                        int percentage = 100 * (this.docCount + 1) / (ConsistencyCheck.this.getDocumentCount() + 1);
                        if (this.jmxAgent != null && percentage != this.lastPercentage) {
                            this.lastPercentage = percentage;
                            this.jmxAgent.updateStatus(ConsistencyCheck.this.broker.getBrokerPool(), percentage);
                        }
                        if (type == 0 && !ConsistencyCheck.this.directAccess) {
                            this.docs.add(doc);
                        }
                    }
                }
                catch (TerminatedException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ErrorReport.ResourceError error = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    error.setDocumentId(docId);
                    if (this.errors != null) {
                        this.errors.add(error);
                    }
                    if (this.progress == null) break block8;
                    this.progress.error(error);
                }
            }
            return true;
        }

        public void checkDocs() {
            DocumentImpl[] documents = new DocumentImpl[this.docs.size()];
            this.docs.toArray(documents);
            Arrays.sort(documents, new Comparator<DocumentImpl>(){

                @Override
                public int compare(DocumentImpl d1, DocumentImpl d2) {
                    long a1 = StorageAddress.pageFromPointer(d1.getFirstChildAddress());
                    long a2 = StorageAddress.pageFromPointer(d2.getFirstChildAddress());
                    return Long.compare(a1, a2);
                }
            });
            for (DocumentImpl doc : documents) {
                ErrorReport report = ConsistencyCheck.this.checkPermissions(doc);
                if (report == null) {
                    report = ConsistencyCheck.this.checkDocs ? ConsistencyCheck.this.checkXMLTree(doc) : ConsistencyCheck.this.checkDocument(doc);
                }
                if (report == null) continue;
                if (report instanceof ErrorReport.ResourceError) {
                    ((ErrorReport.ResourceError)report).setDocumentId(doc.getDocId());
                }
                if (this.errors != null) {
                    this.errors.add(report);
                }
                if (this.progress == null) continue;
                this.progress.error(report);
            }
        }
    }

    private static class ElementNode {
        ElementImpl elem;
        int childCount = 0;
        NodeId prevSibling = null;

        ElementNode(ElementImpl element) {
            this.elem = element;
        }
    }

    public static interface ProgressCallback {
        public void startDocument(String var1, int var2, int var3) throws TerminatedException;

        public void startCollection(String var1) throws TerminatedException;

        public void error(ErrorReport var1);
    }
}

