/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import org.exist.xmldb.XmldbURI;

public class ErrorReport {
    public static final int INCORRECT_NODE_ID = 0;
    public static final int INCORRECT_NODE_TYPE = 1;
    public static final int NODE_HIERARCHY = 2;
    public static final int ACCESS_FAILED = 3;
    public static final int CHILD_COLLECTION = 4;
    public static final int RESOURCE_ACCESS_FAILED = 5;
    public static final int DOM_INDEX = 6;
    public static final int CONFIGURATION_FAILD = 7;
    public static final String[] ERRCODES = new String[]{"ERR_NODE_ID", "ERR_NODE_TYPE", "ERR_NODE_HIERARCHY", "ERR_ACCESS", "ERR_CHILD_COLLECTION", "RESOURCE_ACCESS_FAILED", "ERR_DOM_INDEX"};
    private int code;
    private String message = null;
    private Throwable exception = null;

    public ErrorReport(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public ErrorReport(int code, String message, Throwable exception) {
        this.code = code;
        this.message = message;
        this.exception = exception;
    }

    public int getErrcode() {
        return this.code;
    }

    public String getErrcodeString() {
        return ERRCODES[this.code];
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ERRCODES[this.code]).append(":\n");
        if (this.message != null) {
            sb.append(this.message);
        }
        return sb.toString();
    }

    public static class IndexError
    extends ErrorReport {
        private int documentId = -1;

        public IndexError(int code, String message, int documentId) {
            super(code, message);
            this.documentId = documentId;
        }

        public IndexError(int code, String message, Throwable exception, int documentId) {
            super(code, message, exception);
            this.documentId = documentId;
        }

        public int getDocumentId() {
            return this.documentId;
        }

        @Override
        public String toString() {
            return super.toString() + "\nDocument ID: " + this.documentId;
        }
    }

    public static class CollectionError
    extends ErrorReport {
        private int collectionId = -1;
        private XmldbURI collectionURI = null;

        public CollectionError(int code, String message) {
            super(code, message);
        }

        public CollectionError(int code, String message, Throwable exception) {
            super(code, message, exception);
        }

        public int getCollectionId() {
            return this.collectionId;
        }

        public void setCollectionId(int collectionId) {
            this.collectionId = collectionId;
        }

        public void setCollectionURI(XmldbURI collectionURI) {
            this.collectionURI = collectionURI;
        }

        public XmldbURI getCollectionURI() {
            return this.collectionURI;
        }

        @Override
        public String toString() {
            return super.toString() + "\nCollection ID: " + this.collectionId;
        }
    }

    public static class ResourceError
    extends ErrorReport {
        private int documentId = -1;

        public ResourceError(int code, String message) {
            super(code, message);
        }

        public ResourceError(int code, String message, Throwable exception) {
            super(code, message, exception);
        }

        public int getDocumentId() {
            return this.documentId;
        }

        public void setDocumentId(int documentId) {
            this.documentId = documentId;
        }

        @Override
        public String toString() {
            return super.toString() + "\nDocument ID: " + this.documentId;
        }
    }
}

