/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xquery.TerminatedException;

public class ExportGUI
extends JFrame {
    private static final long serialVersionUID = -8104424554660744639L;
    private BrokerPool pool = null;
    private int documentCount = 0;
    private PrintWriter logWriter = null;
    private JButton btnChangeDir;
    private JButton btnConfSelect;
    private JLabel currentTask;
    private JTextField dbConfig;
    private JButton exportBtn;
    private JCheckBox zipBtn;
    private JCheckBox incrementalBtn;
    private JCheckBox directAccessBtn;
    private JCheckBox scanBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JMenuItem menuQuit;
    private JTextArea messages;
    private JTextField outputDir;
    private JProgressBar progress;
    private JButton startBtn;

    public ExportGUI() {
        super("Consistency Check and Repair");
        this.initComponents();
        String existHome = System.getProperty("exist.home", "./");
        Path home = Paths.get(existHome, new String[0]).normalize();
        this.dbConfig.setText(home.resolve("conf.xml").toAbsolutePath().toString());
        this.outputDir.setText(home.resolve("export").toAbsolutePath().toString());
    }

    protected boolean checkOutputDir() {
        Path dir = Paths.get(this.outputDir.getText(), new String[0]).normalize();
        if (!Files.exists(dir, new LinkOption[0])) {
            if (JOptionPane.showConfirmDialog(this, "The output directory " + dir.toAbsolutePath().toString() + " does not exist. Create it?", "Confirm", 0) == 0) {
                try {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Could not create output dir: " + dir.toAbsolutePath().toString(), "Configuration Error", 0);
                    e.printStackTrace();
                    System.err.println("ERROR: Failed to create output dir: " + e.getMessage());
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean startDB() {
        if (this.pool != null) {
            return true;
        }
        Path confFile = Paths.get(this.dbConfig.getText(), new String[0]).normalize();
        if (!Files.exists(confFile, new LinkOption[0]) || !Files.isReadable(confFile)) {
            JOptionPane.showMessageDialog(this, "The selected database configuration file " + confFile.toAbsolutePath().toString() + " does not exist or is not readable.", "Configuration Error", 0);
            return false;
        }
        try {
            Configuration config = new Configuration(confFile.toAbsolutePath().toString(), Optional.empty());
            BrokerPool.configure(1, 5, config);
            this.pool = BrokerPool.getInstance();
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not start the database instance. Please remember\nthat this tool tries to launch an embedded db instance. No other db instance should\nbe running on the same data.", "DB Error", 0);
            e.printStackTrace();
            System.err.println("ERROR: Failed to open database: " + e.getMessage());
            return false;
        }
    }

    private void initComponents() {
        this.currentTask = new JLabel();
        this.progress = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.messages = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.startBtn = new JButton();
        this.exportBtn = new JButton();
        this.incrementalBtn = new JCheckBox("Incremental");
        this.scanBtn = new JCheckBox("Scan docs");
        this.directAccessBtn = new JCheckBox("Direct access");
        this.zipBtn = new JCheckBox("Create ZIP");
        this.zipBtn.setSelected(true);
        this.outputDir = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnChangeDir = new JButton();
        this.dbConfig = new JTextField();
        this.jLabel2 = new JLabel();
        this.btnConfSelect = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.menuQuit = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                ExportGUI.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.currentTask.setText(" ");
        this.currentTask.setMinimumSize(new Dimension(0, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.currentTask, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.progress, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.jScrollPane2.setPreferredSize(new Dimension(400, 200));
        this.messages.setColumns(20);
        this.messages.setLineWrap(true);
        this.messages.setRows(5);
        this.messages.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane2.setViewportView(this.messages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jToolBar1.setRollover(true);
        this.startBtn.setText("Check");
        this.startBtn.setFocusable(false);
        this.startBtn.setHorizontalTextPosition(0);
        this.startBtn.setVerticalTextPosition(3);
        this.startBtn.addActionListener(this::startBtncheck);
        this.jToolBar1.add(this.startBtn);
        this.exportBtn.setText("Check & Export");
        this.exportBtn.setFocusable(false);
        this.exportBtn.setHorizontalTextPosition(0);
        this.exportBtn.setVerticalTextPosition(3);
        this.exportBtn.addActionListener(this::exportBtnActionPerformed);
        this.jToolBar1.add(this.exportBtn);
        this.jToolBar1.add(this.incrementalBtn);
        this.scanBtn.setSelected(true);
        this.scanBtn.setToolTipText("Perform additional checks; scans every XML document");
        this.jToolBar1.add(this.scanBtn);
        this.directAccessBtn.setToolTipText("Bypass collection index by scanning collection store");
        this.jToolBar1.add(this.directAccessBtn);
        this.jToolBar1.add(this.zipBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.outputDir, gridBagConstraints);
        this.jLabel1.setText("Output Directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.btnChangeDir.setText("Change");
        this.btnChangeDir.addActionListener(this::btnChangeDirActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnChangeDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.dbConfig, gridBagConstraints);
        this.jLabel2.setText("DB Configuration:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.btnConfSelect.setText("Select");
        this.btnConfSelect.setMaximumSize(new Dimension(75, 24));
        this.btnConfSelect.setMinimumSize(new Dimension(75, 24));
        this.btnConfSelect.setPreferredSize(new Dimension(75, 24));
        this.btnConfSelect.addActionListener(this::btnConfSelectActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnConfSelect, gridBagConstraints);
        this.jMenu1.setText("File");
        this.menuQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.menuQuit.setText("Quit");
        this.menuQuit.addActionListener(this::menuQuitActionPerformed);
        this.jMenu1.add(this.menuQuit);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        BrokerPool.stopAll(false);
    }

    private void startBtncheck(ActionEvent evt) {
        if (!this.checkOutputDir()) {
            return;
        }
        Runnable checkRun = () -> {
            this.openLog(this.outputDir.getText());
            try {
                this.checkDB();
            }
            finally {
                this.closeLog();
            }
        };
        new Thread(checkRun).start();
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        if (!this.checkOutputDir()) {
            return;
        }
        Runnable th = () -> {
            this.openLog(this.outputDir.getText());
            try {
                this.currentTask.setText("Checking database consistency ...");
                List<ErrorReport> errors = this.checkDB();
                this.currentTask.setText("Exporting data ...");
                this.exportDB(this.outputDir.getText(), errors);
            }
            finally {
                this.closeLog();
            }
        };
        new Thread(th).start();
    }

    private void btnChangeDirActionPerformed(ActionEvent evt) {
        Path dir = Paths.get(this.outputDir.getText(), new String[0]);
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(dir.resolve("export").toFile());
        chooser.setCurrentDirectory(dir.toFile());
        if (chooser.showDialog(this, "Export") == 0) {
            this.outputDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void menuQuitActionPerformed(ActionEvent evt) {
        BrokerPool.stopAll(false);
        System.exit(0);
    }

    private void btnConfSelectActionPerformed(ActionEvent evt) {
        Path dir = Paths.get(this.dbConfig.getText(), new String[0]).normalize().getParent();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(dir.resolve("conf.xml").toFile());
        chooser.setCurrentDirectory(dir.toFile());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                MimeType mime = MimeTable.getInstance().getContentTypeFor(f.getName());
                if (mime == null) {
                    return false;
                }
                return mime.isXMLType();
            }

            @Override
            public String getDescription() {
                return "Database XML configuration file";
            }
        });
        if (chooser.showDialog(this, "Select") == 0) {
            this.dbConfig.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDB(String exportTarget, List<ErrorReport> errorList) {
        if (!this.startDB()) {
            return;
        }
        try (DBBroker broker = this.pool.get(Optional.of(this.pool.getSecurityManager().getSystemSubject()));){
            SystemExport.StatusCallback callback = new SystemExport.StatusCallback(){

                @Override
                public void startCollection(String path) {
                    ExportGUI.this.progress.setString(path);
                }

                @Override
                public void startDocument(String name, int current, int count) {
                    ExportGUI.this.progress.setString(name);
                    ExportGUI.this.progress.setValue(ExportGUI.this.progress.getValue() + 1);
                }

                @Override
                public void error(String message, Throwable exception) {
                    ExportGUI.this.displayMessage(message);
                    if (exception != null) {
                        ExportGUI.this.displayMessage(exception.toString());
                    }
                    ExportGUI.this.displayMessage("---------------------------------------------------");
                }
            };
            this.progress.setIndeterminate(false);
            this.progress.setValue(0);
            this.progress.setStringPainted(true);
            this.progress.setMinimum(0);
            this.progress.setMaximum(this.documentCount);
            Object[] selected = this.directAccessBtn.getSelectedObjects();
            boolean directAccess = selected != null && selected[0] != null;
            selected = this.incrementalBtn.getSelectedObjects();
            boolean incremental = selected != null && selected[0] != null;
            selected = this.zipBtn.getSelectedObjects();
            boolean zip = selected != null && selected[0] != null;
            this.displayMessage("Starting export ...");
            long start = System.currentTimeMillis();
            SystemExport sysexport = new SystemExport(broker, callback, null, directAccess);
            Path file = sysexport.export(exportTarget, incremental, zip, errorList);
            this.displayMessage("Export to " + file.toAbsolutePath().toString() + " completed successfully.");
            this.displayMessage("Export took " + (System.currentTimeMillis() - start) + "ms.");
            this.progress.setString("");
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
        }
        finally {
            this.progress.setValue(0);
            this.currentTask.setText(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<ErrorReport> checkDB() {
        if (!this.startDB()) {
            return null;
        }
        try {
            List<ErrorReport> list;
            Throwable throwable;
            DBBroker broker;
            block24: {
                block25: {
                    broker = this.pool.get(Optional.of(this.pool.getSecurityManager().getSystemSubject()));
                    throwable = null;
                    Object[] selected = this.directAccessBtn.getSelectedObjects();
                    boolean directAccess = selected != null && selected[0] != null;
                    selected = this.scanBtn.getSelectedObjects();
                    boolean scan = selected != null && selected[0] != null;
                    ConsistencyCheck checker = new ConsistencyCheck(broker, directAccess, scan);
                    ConsistencyCheck.ProgressCallback cb = new ConsistencyCheck.ProgressCallback(){

                        @Override
                        public void startDocument(String path, int current, int count) {
                            ExportGUI.this.progress.setString(path);
                            ExportGUI.this.progress.setValue(ExportGUI.this.progress.getValue() + 1);
                        }

                        @Override
                        public void error(ErrorReport error) {
                            ExportGUI.this.displayMessage(error.toString());
                            ExportGUI.this.displayMessage("---------------------------------------------------");
                        }

                        @Override
                        public void startCollection(String path) {
                            ExportGUI.this.progress.setString(path);
                        }
                    };
                    this.progress.setIndeterminate(true);
                    this.messages.setText("");
                    this.displayMessage("Checking collections ...");
                    List<ErrorReport> errors = checker.checkCollectionTree(cb);
                    if (errors.size() == 0) {
                        this.displayMessage("No errors found.");
                    } else {
                        this.displayMessage("Errors found.");
                    }
                    this.progress.setStringPainted(true);
                    this.progress.setString("Counting documents ...");
                    this.documentCount = checker.getDocumentCount();
                    this.progress.setIndeterminate(false);
                    this.progress.setValue(0);
                    this.progress.setMinimum(0);
                    this.progress.setMaximum(this.documentCount);
                    this.displayMessage("Checking documents ...");
                    checker.checkDocuments(cb, errors);
                    if (errors.size() == 0) {
                        this.displayMessage("No errors found.");
                    } else {
                        this.displayMessage("Errors found.");
                    }
                    this.progress.setString("");
                    list = errors;
                    if (broker == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        broker.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                broker.close();
            }
            return list;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (broker != null) {
                            if (throwable != null) {
                                try {
                                    broker.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                broker.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (EXistException | PermissionDeniedException e) {
                    System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
                }
                catch (TerminatedException e) {
                    System.err.println("WARN: Check terminated by db.");
                }
            }
        }
        finally {
            this.progress.setValue(0);
            this.currentTask.setText(" ");
        }
        return null;
    }

    public void displayMessage(String message) {
        this.messages.append(message + '\n');
        this.messages.setCaretPosition(this.messages.getDocument().getLength());
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    private void openLog(String dir) {
        Path file = SystemExport.getUniqueFile("report", ".log", dir);
        try {
            this.logWriter = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
        }
        catch (IOException e) {
            System.err.println("ERROR: failed to create log file");
        }
    }

    private void closeLog() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new ExportGUI().setVisible(true));
    }
}

